/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetBloomRowGroupFilter;
import org.apache.iceberg.parquet.ParquetDictionaryRowGroupFilter;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetMetricsRowGroupFilter;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.MessageType;

class ReadConf<T> {
    private final ParquetFileReader reader;
    private final InputFile file;
    private final ParquetReadOptions options;
    private final MessageType projection;
    private final ParquetValueReader<T> model;
    private final VectorizedReader<T> vectorizedModel;
    private final List<BlockMetaData> rowGroups;
    private final boolean[] shouldSkip;
    private final long totalValues;
    private final boolean reuseContainers;
    private final Integer batchSize;
    private final List<Map<ColumnPath, ColumnChunkMetaData>> columnChunkMetaDataForRowGroups;

    ReadConf(InputFile file, ParquetReadOptions options, Schema expectedSchema, Expression filter, Function<MessageType, ParquetValueReader<?>> readerFunc, Function<MessageType, VectorizedReader<?>> batchedReaderFunc, NameMapping nameMapping, boolean reuseContainers, boolean caseSensitive, Integer bSize) {
        MessageType typeWithIds;
        this.file = file;
        this.options = options;
        this.reader = ReadConf.newReader(file, options);
        MessageType fileSchema = this.reader.getFileMetaData().getSchema();
        if (ParquetSchemaUtil.hasIds(fileSchema)) {
            typeWithIds = fileSchema;
            this.projection = ParquetSchemaUtil.pruneColumns(fileSchema, expectedSchema);
        } else if (nameMapping != null) {
            typeWithIds = ParquetSchemaUtil.applyNameMapping(fileSchema, nameMapping);
            this.projection = ParquetSchemaUtil.pruneColumns(typeWithIds, expectedSchema);
        } else {
            typeWithIds = ParquetSchemaUtil.addFallbackIds(fileSchema);
            this.projection = ParquetSchemaUtil.pruneColumnsFallback(fileSchema, expectedSchema);
        }
        this.rowGroups = this.reader.getRowGroups();
        this.shouldSkip = new boolean[this.rowGroups.size()];
        ParquetMetricsRowGroupFilter statsFilter = null;
        ParquetDictionaryRowGroupFilter dictFilter = null;
        ParquetBloomRowGroupFilter bloomFilter = null;
        if (filter != null) {
            statsFilter = new ParquetMetricsRowGroupFilter(expectedSchema, filter, caseSensitive);
            dictFilter = new ParquetDictionaryRowGroupFilter(expectedSchema, filter, caseSensitive);
            bloomFilter = new ParquetBloomRowGroupFilter(expectedSchema, filter, caseSensitive);
        }
        long computedTotalValues = 0L;
        for (int i = 0; i < this.shouldSkip.length; ++i) {
            BlockMetaData rowGroup = this.rowGroups.get(i);
            boolean shouldRead = filter == null || statsFilter.shouldRead(typeWithIds, rowGroup) && dictFilter.shouldRead(typeWithIds, rowGroup, this.reader.getDictionaryReader(rowGroup)) && bloomFilter.shouldRead(typeWithIds, rowGroup, this.reader.getBloomFilterDataReader(rowGroup));
            boolean bl = this.shouldSkip[i] = !shouldRead;
            if (!shouldRead) continue;
            computedTotalValues += rowGroup.getRowCount();
        }
        this.totalValues = computedTotalValues;
        if (readerFunc != null) {
            this.model = readerFunc.apply(typeWithIds);
            this.vectorizedModel = null;
            this.columnChunkMetaDataForRowGroups = null;
        } else {
            this.model = null;
            this.vectorizedModel = batchedReaderFunc.apply(typeWithIds);
            this.columnChunkMetaDataForRowGroups = this.getColumnChunkMetadataForRowGroups();
        }
        this.reuseContainers = reuseContainers;
        this.batchSize = bSize;
    }

    private ReadConf(ReadConf<T> toCopy) {
        this.reader = null;
        this.file = toCopy.file;
        this.options = toCopy.options;
        this.projection = toCopy.projection;
        this.model = toCopy.model;
        this.rowGroups = toCopy.rowGroups;
        this.shouldSkip = toCopy.shouldSkip;
        this.totalValues = toCopy.totalValues;
        this.reuseContainers = toCopy.reuseContainers;
        this.batchSize = toCopy.batchSize;
        this.vectorizedModel = toCopy.vectorizedModel;
        this.columnChunkMetaDataForRowGroups = toCopy.columnChunkMetaDataForRowGroups;
    }

    ParquetFileReader reader() {
        if (this.reader != null) {
            this.reader.setRequestedSchema(this.projection);
            return this.reader;
        }
        ParquetFileReader newReader = ReadConf.newReader(this.file, this.options);
        newReader.setRequestedSchema(this.projection);
        return newReader;
    }

    ParquetValueReader<T> model() {
        return this.model;
    }

    VectorizedReader<T> vectorizedModel() {
        return this.vectorizedModel;
    }

    boolean[] shouldSkip() {
        return this.shouldSkip;
    }

    long totalValues() {
        return this.totalValues;
    }

    boolean reuseContainers() {
        return this.reuseContainers;
    }

    Integer batchSize() {
        return this.batchSize;
    }

    List<Map<ColumnPath, ColumnChunkMetaData>> columnChunkMetadataForRowGroups() {
        return this.columnChunkMetaDataForRowGroups;
    }

    ReadConf<T> copy() {
        return new ReadConf<T>(this);
    }

    private static ParquetFileReader newReader(InputFile file, ParquetReadOptions options) {
        try {
            return ParquetFileReader.open(ParquetIO.file(file), options);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to open Parquet file: %s", file.location());
        }
    }

    private List<Map<ColumnPath, ColumnChunkMetaData>> getColumnChunkMetadataForRowGroups() {
        Set projectedColumns = this.projection.getColumns().stream().map(columnDescriptor -> ColumnPath.get(columnDescriptor.getPath())).collect(Collectors.toSet());
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int i = 0; i < this.rowGroups.size(); ++i) {
            if (!this.shouldSkip[i]) {
                BlockMetaData blockMetaData = this.rowGroups.get(i);
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                blockMetaData.getColumns().stream().filter(columnChunkMetaData -> projectedColumns.contains(columnChunkMetaData.getPath())).forEach(columnChunkMetaData -> mapBuilder.put(columnChunkMetaData.getPath(), columnChunkMetaData));
                listBuilder.add(mapBuilder.build());
                continue;
            }
            listBuilder.add(ImmutableMap.of());
        }
        return listBuilder.build();
    }
}

