/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.Endpoint;
import org.apache.iceberg.rest.RESTResponse;

public class ConfigResponse
implements RESTResponse {
    private Map<String, String> defaults;
    private Map<String, String> overrides;
    private List<Endpoint> endpoints;

    public ConfigResponse() {
    }

    private ConfigResponse(Map<String, String> defaults, Map<String, String> overrides, List<Endpoint> endpoints) {
        this.defaults = defaults;
        this.overrides = overrides;
        this.endpoints = endpoints;
        this.validate();
    }

    @Override
    public void validate() {
    }

    public Map<String, String> defaults() {
        return this.defaults != null ? this.defaults : ImmutableMap.of();
    }

    public Map<String, String> overrides() {
        return this.overrides != null ? this.overrides : ImmutableMap.of();
    }

    public List<Endpoint> endpoints() {
        return null != this.endpoints ? this.endpoints : ImmutableList.of();
    }

    public Map<String, String> merge(Map<String, String> clientProperties) {
        Preconditions.checkNotNull(clientProperties, "Cannot merge client properties with server-provided properties. Invalid client configuration: null");
        HashMap<String, String> merged = this.defaults != null ? Maps.newHashMap(this.defaults) : Maps.newHashMap();
        merged.putAll(clientProperties);
        if (this.overrides != null) {
            merged.putAll(this.overrides);
        }
        return ImmutableMap.copyOf(Maps.filterValues(merged, Objects::nonNull));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("defaults", this.defaults).add("overrides", this.overrides).add("endpoints", this.endpoints).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> defaults = Maps.newHashMap();
        private final Map<String, String> overrides = Maps.newHashMap();
        private final List<Endpoint> endpoints = Lists.newArrayList();

        private Builder() {
        }

        public Builder withDefault(String key, String value) {
            Preconditions.checkNotNull(key, "Invalid default property: null");
            this.defaults.put(key, value);
            return this;
        }

        public Builder withOverride(String key, String value) {
            Preconditions.checkNotNull(key, "Invalid override property: null");
            this.overrides.put(key, value);
            return this;
        }

        public Builder withDefaults(Map<String, String> defaultsToAdd) {
            Preconditions.checkNotNull(defaultsToAdd, "Invalid default properties map: null");
            Preconditions.checkArgument(!defaultsToAdd.containsKey(null), "Invalid default property: null");
            this.defaults.putAll(defaultsToAdd);
            return this;
        }

        public Builder withOverrides(Map<String, String> overridesToAdd) {
            Preconditions.checkNotNull(overridesToAdd, "Invalid override properties map: null");
            Preconditions.checkArgument(!overridesToAdd.containsKey(null), "Invalid override property: null");
            this.overrides.putAll(overridesToAdd);
            return this;
        }

        public Builder withEndpoints(List<Endpoint> endpointsToAdd) {
            this.endpoints.addAll(endpointsToAdd);
            return this;
        }

        public ConfigResponse build() {
            return new ConfigResponse(this.defaults, this.overrides, this.endpoints);
        }
    }
}

