/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.oauth2;

import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.metastore.auth.HttpAuthenticationException;
import org.apache.hadoop.hive.metastore.auth.oauth2.OAuth2PrincipalMapper;

public class RegexOAuth2PrincipalMapper
implements OAuth2PrincipalMapper {
    private final String claimName;
    private final Pattern pattern;

    RegexOAuth2PrincipalMapper(String claimName, Pattern pattern) {
        this.claimName = claimName;
        this.pattern = pattern;
    }

    @Override
    public String getUserName(OAuth2PrincipalMapper.ClaimProvider rawValueProvider) throws HttpAuthenticationException {
        String rawValue = rawValueProvider.provide(this.claimName);
        if (rawValue == null) {
            BearerTokenError error = BearerTokenError.INVALID_TOKEN;
            throw new HttpAuthenticationException("Authentication error: Claim '%s' not found in token".formatted(this.claimName), error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
        Matcher matcher = this.pattern.matcher(rawValue);
        if (!matcher.find()) {
            BearerTokenError error = BearerTokenError.INVALID_TOKEN;
            throw new HttpAuthenticationException("Authentication error: Claim '%s' does not match %s".formatted(this.claimName, this.pattern.pattern()), error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
        if (matcher.groupCount() != 1) {
            throw new IllegalStateException("Pattern must extract exactly one group, but %s picked up %d groups".formatted(this.pattern.pattern(), matcher.groupCount()));
        }
        return matcher.group(1);
    }
}

