/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalColumnStatsMerger
extends ColumnStatsMerger<Decimal> {
    private static final Logger LOG = LoggerFactory.getLogger(DecimalColumnStatsMerger.class);

    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        Decimal highValue;
        LOG.debug("Merging statistics: [aggregateColStats:{}, newColStats: {}]", (Object)aggregateColStats, (Object)newColStats);
        DecimalColumnStatsDataInspector aggregateData = ColumnsStatsUtils.decimalInspectorFromStats(aggregateColStats);
        DecimalColumnStatsDataInspector newData = ColumnsStatsUtils.decimalInspectorFromStats(newColStats);
        Decimal lowValue = this.mergeLowValue(this.getLowValue(aggregateData), this.getLowValue(newData));
        if (lowValue != null) {
            aggregateData.setLowValue(lowValue);
        }
        if ((highValue = this.mergeHighValue(this.getHighValue(aggregateData), this.getHighValue(newData))) != null) {
            aggregateData.setHighValue(highValue);
        }
        aggregateData.setNumNulls(this.mergeNumNulls(aggregateData.getNumNulls(), newData.getNumNulls()));
        NumDistinctValueEstimator oldNDVEst = aggregateData.getNdvEstimator();
        NumDistinctValueEstimator newNDVEst = newData.getNdvEstimator();
        List<NumDistinctValueEstimator> ndvEstimatorsList = Arrays.asList(oldNDVEst, newNDVEst);
        aggregateData.setNumDVs(this.mergeNumDistinctValueEstimator(aggregateColStats.getColName(), ndvEstimatorsList, aggregateData.getNumDVs(), newData.getNumDVs()));
        aggregateData.setNdvEstimator(ndvEstimatorsList.get(0));
        KllHistogramEstimator oldKllEst = aggregateData.getHistogramEstimator();
        KllHistogramEstimator newKllEst = newData.getHistogramEstimator();
        aggregateData.setHistogramEstimator(this.mergeHistogramEstimator(aggregateColStats.getColName(), oldKllEst, newKllEst));
        aggregateColStats.getStatsData().setDecimalStats((DecimalColumnStatsData)aggregateData);
    }

    public Decimal getLowValue(DecimalColumnStatsDataInspector data) {
        return data.isSetLowValue() ? data.getLowValue() : null;
    }

    public Decimal getHighValue(DecimalColumnStatsDataInspector data) {
        return data.isSetHighValue() ? data.getHighValue() : null;
    }

    @Override
    public Decimal mergeLowValue(Decimal oldValue, Decimal newValue) {
        if (oldValue != null && newValue != null) {
            return (Decimal)ObjectUtils.min((Comparable[])new Decimal[]{oldValue, newValue});
        }
        if (oldValue != null || newValue != null) {
            return (Decimal)MoreObjects.firstNonNull((Object)oldValue, (Object)newValue);
        }
        return null;
    }

    @Override
    public Decimal mergeHighValue(Decimal oldValue, Decimal newValue) {
        if (oldValue != null && newValue != null) {
            return (Decimal)ObjectUtils.max((Comparable[])new Decimal[]{oldValue, newValue});
        }
        if (oldValue != null || newValue != null) {
            return (Decimal)MoreObjects.firstNonNull((Object)oldValue, (Object)newValue);
        }
        return null;
    }
}

