/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DatabaseType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.dataconnector.IDataConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.JDBCConnectorProviderFactory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConnectorProviderFactory {
    static final Logger LOG = LoggerFactory.getLogger(DataConnectorProviderFactory.class);
    private static Cache<String, IDataConnectorProvider> dataConnectorCache = null;
    private static DataConnectorProviderFactory singleton = null;
    private static IHMSHandler hmsHandler = null;

    private DataConnectorProviderFactory(IHMSHandler hmsHandler) {
        dataConnectorCache = Caffeine.newBuilder().removalListener((RemovalListener)new CacheRemoveListener()).maximumSize(100L).expireAfterAccess(1L, TimeUnit.HOURS).build();
        DataConnectorProviderFactory.hmsHandler = hmsHandler;
    }

    public static synchronized DataConnectorProviderFactory getInstance(IHMSHandler hmsHandler) {
        if (singleton == null) {
            singleton = new DataConnectorProviderFactory(hmsHandler);
        }
        return singleton;
    }

    public static synchronized IDataConnectorProvider getDataConnectorProvider(Database db) throws MetaException {
        String type;
        IDataConnectorProvider provider = null;
        DataConnector connector = null;
        if (db.getType() == DatabaseType.NATIVE) {
            throw new MetaException("Database " + db.getName() + " is of type NATIVE, no connector available");
        }
        String scopedDb = db.getRemote_dbname() != null ? db.getRemote_dbname() : db.getName();
        provider = (IDataConnectorProvider)dataConnectorCache.getIfPresent((Object)db.getConnector_name().toLowerCase());
        if (provider != null) {
            provider.setScope(scopedDb);
            return provider;
        }
        try {
            connector = hmsHandler.get_dataconnector_core(db.getConnector_name());
        }
        catch (NoSuchObjectException notexists) {
            throw new MetaException("Data connector " + db.getConnector_name() + " associated with database " + db.getName() + " does not exist");
        }
        switch (type = connector.getType()) {
            case "derby": 
            case "hivejdbc": 
            case "mssql": 
            case "mysql": 
            case "oracle": 
            case "postgres": {
                try {
                    provider = JDBCConnectorProviderFactory.get(scopedDb, connector);
                    break;
                }
                catch (Exception e) {
                    throw new MetaException("Could not instantiate a provider for database " + db.getName());
                }
            }
            default: {
                throw new MetaException("Data connector of type " + connector.getType() + " not implemented yet");
            }
        }
        dataConnectorCache.put((Object)connector.getName().toLowerCase(), (Object)provider);
        return provider;
    }

    public static synchronized void invalidateDataConnectorFromCache(String dcName) {
        try {
            IDataConnectorProvider dataConnectorProvider = (IDataConnectorProvider)dataConnectorCache.getIfPresent((Object)dcName);
            if (dataConnectorProvider != null) {
                dataConnectorCache.invalidate((Object)dcName);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception when removing dataConnectorProvider: {} from cache due to: {}" + dcName, (Object)e.getMessage());
        }
    }

    private static class CacheRemoveListener
    implements RemovalListener<String, IDataConnectorProvider> {
        private CacheRemoveListener() {
        }

        public void onRemoval(@Nullable String dcName, @Nullable IDataConnectorProvider dataConnectorProvider, @NonNull RemovalCause cause) {
            try {
                LOG.info("Closing dataConnectorProvider :{}", (Object)dcName);
                dataConnectorProvider.close();
            }
            catch (Exception e) {
                LOG.warn("Exception when closing dataConnectorProvider: {} due to: {}" + dcName, (Object)e.getMessage());
            }
        }
    }
}

