/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AlterDatabaseEvent
extends ListenerEvent {
    private final Database oldDb;
    private final Database newDb;
    private final boolean isReplicated;
    private final List<String> replDbProps = MetaStoreUtils.getReplicationDbProps();

    public AlterDatabaseEvent(Database oldDb, Database newDb, boolean status, IHMSHandler handler, boolean isReplicated) {
        super(status, handler);
        this.oldDb = new Database(oldDb);
        this.newDb = new Database(newDb);
        this.filterOutReplProps(this.oldDb.getParameters());
        this.filterOutReplProps(this.newDb.getParameters());
        this.isReplicated = isReplicated;
    }

    private void filterOutReplProps(Map<String, String> dbProps) {
        if (dbProps == null) {
            return;
        }
        ArrayList<String> propsToRemove = new ArrayList<String>();
        for (Map.Entry<String, String> prop : dbProps.entrySet()) {
            String propName = prop.getKey().replace("\"", "");
            if (!propName.startsWith("bootstrap.dump.state.") && !this.replDbProps.contains(propName)) continue;
            propsToRemove.add(prop.getKey());
        }
        for (String key : propsToRemove) {
            dbProps.remove(key);
        }
    }

    public boolean shouldSkipCapturing() {
        if (this.oldDb.getOwnerType() == this.newDb.getOwnerType() && this.oldDb.getOwnerName().equalsIgnoreCase(this.newDb.getOwnerName())) {
            Map newDbProps = this.newDb.getParameters();
            Map oldDbProps = this.oldDb.getParameters();
            return newDbProps == null || newDbProps.isEmpty() ? oldDbProps == null || oldDbProps.isEmpty() : newDbProps.equals(oldDbProps);
        }
        return false;
    }

    public Database getOldDatabase() {
        return this.oldDb;
    }

    public Database getNewDatabase() {
        return this.newDb;
    }

    public boolean isReplicated() {
        return this.isReplicated;
    }
}

