/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json.gzip;

import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.MessageSerializer;
import org.apache.hadoop.hive.metastore.messaging.json.gzip.DeSerializer;
import org.apache.hadoop.hive.metastore.messaging.json.gzip.Serializer;

public class GzipJSONMessageEncoder
implements MessageEncoder {
    public static final String FORMAT = "gzip(json-2.0)";
    private static DeSerializer deSerializer;
    private static Serializer serializer;
    private static volatile MessageEncoder instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageEncoder getInstance() {
        if (instance != null) return instance;
        Class<GzipJSONMessageEncoder> clazz = GzipJSONMessageEncoder.class;
        synchronized (GzipJSONMessageEncoder.class) {
            if (instance != null) return instance;
            instance = new GzipJSONMessageEncoder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public MessageDeserializer getDeserializer() {
        return deSerializer;
    }

    @Override
    public MessageSerializer getSerializer() {
        return serializer;
    }

    @Override
    public String getMessageFormat() {
        return FORMAT;
    }

    static {
        MessageFactory.register(FORMAT, GzipJSONMessageEncoder.class);
        deSerializer = new DeSerializer();
        serializer = new Serializer();
    }
}

