/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public final class SQLGenerator {
    private static final Logger LOG = LoggerFactory.getLogger((String)SQLGenerator.class.getName());
    private final DatabaseProduct dbProduct;
    private final Configuration conf;

    public SQLGenerator(DatabaseProduct dbProduct, Configuration conf) {
        this.dbProduct = dbProduct;
        this.conf = conf;
    }

    public List<PreparedStatement> createInsertValuesPreparedStmt(Connection dbConn, String tblColumns, List<String> rows, List<List<String>> paramsList) throws SQLException {
        if (rows == null || rows.size() == 0) {
            return Collections.emptyList();
        }
        assert (paramsList == null || rows.size() == paramsList.size());
        ArrayList<Integer> rowsCountInStmts = new ArrayList<Integer>();
        List<String> insertStmts = this.createInsertValuesStmt(tblColumns, rows, rowsCountInStmts);
        assert (insertStmts.size() == rowsCountInStmts.size());
        ArrayList<PreparedStatement> preparedStmts = new ArrayList<PreparedStatement>();
        int paramsListFromIdx = 0;
        try {
            for (int stmtIdx = 0; stmtIdx < insertStmts.size(); ++stmtIdx) {
                String sql = insertStmts.get(stmtIdx);
                PreparedStatement pStmt = this.prepareStmtWithParameters(dbConn, sql, null);
                if (paramsList != null) {
                    int paramIdx = 1;
                    int paramsListToIdx = paramsListFromIdx + (Integer)rowsCountInStmts.get(stmtIdx);
                    for (int paramsListIdx = paramsListFromIdx; paramsListIdx < paramsListToIdx; ++paramsListIdx) {
                        List<String> params = paramsList.get(paramsListIdx);
                        int i = 0;
                        while (i < params.size()) {
                            pStmt.setString(paramIdx, params.get(i));
                            ++i;
                            ++paramIdx;
                        }
                    }
                    paramsListFromIdx = paramsListToIdx;
                }
                preparedStmts.add(pStmt);
            }
        }
        catch (SQLException e) {
            for (PreparedStatement pst : preparedStmts) {
                pst.close();
            }
            throw e;
        }
        return preparedStmts;
    }

    public List<String> createInsertValuesStmt(String tblColumns, List<String> rows) {
        return this.createInsertValuesStmt(tblColumns, rows, null);
    }

    private List<String> createInsertValuesStmt(String tblColumns, List<String> rows, List<Integer> rowsCountInStmts) {
        if (rows == null || rows.size() == 0) {
            return Collections.emptyList();
        }
        return this.dbProduct.createInsertValuesStmt(tblColumns, rows, rowsCountInStmts, this.conf);
    }

    public String addForUpdateClause(String selectStatement) throws MetaException {
        return this.dbProduct.addForUpdateClause(selectStatement);
    }

    public String addLimitClause(int numRows, String noSelectsqlQuery) throws MetaException {
        return this.dbProduct.addLimitClause(numRows, noSelectsqlQuery);
    }

    public String lockTable(String txnLockTable, boolean shared) throws MetaException {
        return this.dbProduct.lockTable(txnLockTable, shared);
    }

    public PreparedStatement prepareStmtWithParameters(Connection dbConn, String sql, List<String> parameters) throws SQLException {
        PreparedStatement pst = dbConn.prepareStatement(this.addEscapeCharacters(sql));
        if (parameters == null || parameters.isEmpty()) {
            return pst;
        }
        try {
            for (int i = 1; i <= parameters.size(); ++i) {
                pst.setString(i, parameters.get(i - 1));
            }
        }
        catch (SQLException e) {
            pst.close();
            throw e;
        }
        return pst;
    }

    public DatabaseProduct getDbProduct() {
        return this.dbProduct;
    }

    public String addEscapeCharacters(String s) {
        return this.dbProduct.addEscapeCharacters(s);
    }

    public String createTxnLockStatement(boolean shared) throws MetaException {
        String txnLockTable = "TXN_LOCK_TBL";
        return this.dbProduct.lockTable(txnLockTable, shared);
    }
}

