/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.TxnLockManager;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.LockInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.RollbackException;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.CheckLockFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.EnqueueLockFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetLocksByLockId;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.ShowLocksHandler;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class DefaultTxnLockManager
implements TxnLockManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTxnLockManager.class);
    private final MultiDataSourceJdbcResource jdbcResource;

    public DefaultTxnLockManager(MultiDataSourceJdbcResource jdbcResource) {
        this.jdbcResource = jdbcResource;
    }

    @Override
    public long enqueueLock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        return new EnqueueLockFunction(rqst).execute(this.jdbcResource);
    }

    @Override
    public LockResponse checkLock(long extLockId, long txnId, boolean zeroWaitReadEnabled, boolean isExclusiveCTAS) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        return new CheckLockFunction(extLockId, txnId, zeroWaitReadEnabled, isExclusiveCTAS).execute(this.jdbcResource);
    }

    @Override
    public void unlock(UnlockRequest rqst) throws TxnOpenException, MetaException {
        long extLockId = rqst.getLockid();
        int rc = this.jdbcResource.getJdbcTemplate().update("DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = :extLockId  AND (\"HL_TXNID\" = 0 OR (\"HL_TXNID\" <> 0 AND \"HL_LOCK_STATE\" = :state))", (SqlParameterSource)new MapSqlParameterSource().addValue("extLockId", (Object)extLockId).addValue("state", (Object)Character.toString('w'), 1));
        if (rc < 1) {
            LOG.info("Failure to unlock any locks with extLockId={}.", (Object)extLockId);
            List<LockInfo> lockInfos = this.jdbcResource.execute(new GetLocksByLockId(extLockId, 1, this.jdbcResource.getSqlGenerator()));
            if (CollectionUtils.isEmpty(lockInfos)) {
                LOG.info("No lock in {} mode found for unlock({})", (Object)Character.valueOf('w'), (Object)JavaUtils.lockIdToString((long)rqst.getLockid()));
                throw new RollbackException((Object)null);
            }
            LockInfo lockInfo = lockInfos.get(0);
            if (TxnUtils.isValidTxn(lockInfo.getTxnId())) {
                String msg = "Unlocking locks associated with transaction not permitted.  " + String.valueOf(lockInfo);
                LOG.error(msg);
                throw new TxnOpenException(msg);
            }
            String msg = "Found lock in unexpected state " + String.valueOf(lockInfo);
            LOG.error(msg);
            throw new MetaException(msg);
        }
        LOG.debug("Successfully unlocked at least 1 lock with extLockId={}", (Object)extLockId);
    }

    @Override
    public ShowLocksResponse showLocks(ShowLocksRequest rqst) throws MetaException {
        return this.jdbcResource.execute(new ShowLocksHandler(rqst));
    }
}

