/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.entities;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.LockTypeUtil;

public class LockInfo {
    public static final char LOCK_ACQUIRED = 'a';
    public static final char LOCK_WAITING = 'w';
    private final long extLockId;
    private final long intLockId;
    private final long txnId;
    private final String db;
    private final String table;
    private final String partition;
    private final LockState state;
    private final LockType type;

    public LockInfo(ResultSet rs) throws SQLException, MetaException {
        this.extLockId = rs.getLong("HL_LOCK_EXT_ID");
        this.intLockId = rs.getLong("HL_LOCK_INT_ID");
        this.db = rs.getString("HL_DB");
        String t = rs.getString("HL_TABLE");
        this.table = rs.wasNull() ? null : t;
        String p = rs.getString("HL_PARTITION");
        this.partition = rs.wasNull() ? null : p;
        switch (rs.getString("HL_LOCK_STATE").charAt(0)) {
            case 'w': {
                this.state = LockState.WAITING;
                break;
            }
            case 'a': {
                this.state = LockState.ACQUIRED;
                break;
            }
            default: {
                throw new MetaException("Unknown lock state " + rs.getString("HL_LOCK_STATE").charAt(0));
            }
        }
        char lockChar = rs.getString("HL_LOCK_TYPE").charAt(0);
        this.type = LockTypeUtil.getLockTypeFromEncoding(lockChar).orElseThrow(() -> new MetaException("Unknown lock type: " + lockChar));
        this.txnId = rs.getLong("HL_TXNID");
    }

    public LockInfo(ShowLocksResponseElement e) {
        this.extLockId = e.getLockid();
        this.intLockId = e.getLockIdInternal();
        this.txnId = e.getTxnid();
        this.db = e.getDbname();
        this.table = e.getTablename();
        this.partition = e.getPartname();
        this.state = e.getState();
        this.type = e.getType();
    }

    public long getExtLockId() {
        return this.extLockId;
    }

    public long getIntLockId() {
        return this.intLockId;
    }

    public long getTxnId() {
        return this.txnId;
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public String getPartition() {
        return this.partition;
    }

    public LockState getState() {
        return this.state;
    }

    public LockType getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LockInfo)) {
            return false;
        }
        LockInfo o = (LockInfo)other;
        return this.extLockId == o.extLockId && this.intLockId == o.intLockId;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.intLockId).append(this.extLockId).append(this.txnId).append((Object)this.db).build();
    }

    public String toString() {
        return JavaUtils.lockIdToString((long)this.extLockId) + " intLockId:" + this.intLockId + " " + JavaUtils.txnIdToString((long)this.txnId) + " db:" + this.db + " table:" + this.table + " partition:" + this.partition + " state:" + (this.state == null ? "null" : this.state.toString()) + " type:" + (this.type == null ? "null" : this.type.toString());
    }

    private boolean isDbLock() {
        return this.db != null && this.table == null && this.partition == null;
    }

    private boolean isTableLock() {
        return this.db != null && this.table != null && this.partition == null;
    }

    private boolean isPartitionLock() {
        return !this.isDbLock() && !this.isTableLock();
    }
}

