/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GenerateCompactionQueueIdFunction
implements TransactionalFunction<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateCompactionQueueIdFunction.class);

    @Override
    public Long execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        String sql = jdbcResource.getSqlGenerator().addForUpdateClause("SELECT \"NCQ_NEXT\" FROM \"NEXT_COMPACTION_QUEUE_ID\"");
        LOG.debug("going to execute SQL <{}>", (Object)sql);
        Long allocatedId = (Long)jdbcResource.getJdbcTemplate().query(sql, rs -> {
            if (!rs.next()) {
                throw new IllegalStateException("Transaction tables not properly initiated, no record found in next_compaction_queue_id");
            }
            long id = rs.getLong(1);
            int count = jdbcResource.getJdbcTemplate().update("UPDATE \"NEXT_COMPACTION_QUEUE_ID\" SET \"NCQ_NEXT\" = :newId WHERE \"NCQ_NEXT\" = :id", (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)id).addValue("newId", (Object)(id + 1L)));
            if (count != 1) {
                LOG.info("The returned compaction ID ({}) already taken, obtaining new", (Object)id);
                return null;
            }
            return id;
        });
        if (allocatedId == null) {
            return this.execute(jdbcResource);
        }
        return allocatedId;
    }
}

