/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.service;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.NoMutex;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidTxnCleanerService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidTxnCleanerService.class);
    private Configuration conf;
    private TxnStore txnHandler;
    private boolean shouldUseMutex = true;

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ACID_TXN_CLEANER_INTERVAL, (TimeUnit)unit);
    }

    public void run() {
        TxnStore.MutexAPI mutex = this.shouldUseMutex ? this.txnHandler.getMutexAPI() : new NoMutex();
        try (TxnStore.MutexAPI.LockHandle closeable = mutex.acquireLock(TxnStore.MUTEX_KEY.TxnCleaner.name());){
            long start = System.currentTimeMillis();
            this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
            LOG.debug("Txn cleaner service took: {} seconds.", (Object)this.elapsedSince(start));
        }
        catch (Exception e) {
            LOG.error("Unexpected exception in thread: {}, message: {}", new Object[]{Thread.currentThread().getName(), e.getMessage(), e});
        }
    }

    private long elapsedSince(long start) {
        return (System.currentTimeMillis() - start) / 1000L;
    }

    public void enforceMutex(boolean enableMutex) {
        this.shouldUseMutex = enableMutex;
    }
}

