/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.show;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.catalog.show.ShowCatalogsDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1207})
public class ShowCatalogsAnalyzer
extends BaseSemanticAnalyzer {
    public ShowCatalogsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() > 1) {
            throw new SemanticException("Unexpected Tokens at SHOW CATALOGS");
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String catalogPattern = root.getChildCount() == 1 ? ShowCatalogsAnalyzer.unescapeSQLString(root.getChild(0).getText()) : null;
        ShowCatalogsDesc desc = new ShowCatalogsDesc(this.ctx.getResFile(), catalogPattern);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("catalog_name#string"));
    }
}

