/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.unlock;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.unlock.UnlockDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1307})
public class UnlockDatabaseAnalyzer
extends BaseSemanticAnalyzer {
    public UnlockDatabaseAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String databaseName = UnlockDatabaseAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        this.inputs.add(new ReadEntity(this.getDatabase(databaseName)));
        this.outputs.add(new WriteEntity(this.getDatabase(databaseName), WriteEntity.WriteType.DDL_NO_LOCK));
        UnlockDatabaseDesc desc = new UnlockDatabaseDesc(databaseName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.ctx.setNeedLockMgr(true);
    }
}

