/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.macro.create;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Explain(displayName="Create Macro", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateMacroDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String macroName;
    private final List<String> columnNames;
    private final List<TypeInfo> columnTypes;
    private final ExprNodeDesc body;

    public CreateMacroDesc(String macroName, List<String> columnNames, List<TypeInfo> columnTypes, ExprNodeDesc body) {
        this.macroName = macroName;
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.body = body;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getName() {
        return this.macroName;
    }

    @Explain(displayName="column names", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<TypeInfo> getColumnTypes() {
        return this.columnTypes;
    }

    @Explain(displayName="column types", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getColumnTypeStrings() {
        return this.columnTypes.stream().map(typeInfo -> typeInfo.getTypeName()).collect(Collectors.toList());
    }

    public ExprNodeDesc getBody() {
        return this.body;
    }

    @Explain(displayName="body", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getBodyString() {
        return this.body.toString();
    }
}

