/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege.role.revoke;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeUtils;
import org.apache.hadoop.hive.ql.ddl.privilege.role.revoke.RevokeRoleDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;

public class RevokeRoleOperation
extends DDLOperation<RevokeRoleDesc> {
    public RevokeRoleOperation(DDLOperationContext context, RevokeRoleDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        HiveAuthorizer authorizer = PrivilegeUtils.getSessionAuthorizer(this.context.getConf());
        List<HivePrincipal> principals = AuthorizationUtils.getHivePrincipals(((RevokeRoleDesc)this.desc).getPrincipals(), PrivilegeUtils.getAuthorizationTranslator(authorizer));
        HivePrincipal grantorPrincipal = null;
        if (((RevokeRoleDesc)this.desc).getGrantor() != null) {
            grantorPrincipal = new HivePrincipal(((RevokeRoleDesc)this.desc).getGrantor(), AuthorizationUtils.getHivePrincipalType(PrincipalType.USER));
        }
        authorizer.revokeRole(principals, ((RevokeRoleDesc)this.desc).getRoles(), ((RevokeRoleDesc)this.desc).isGrantOption(), grantorPrincipal);
        return 0;
    }
}

