/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableWithConstraintsDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.constraint.add.AlterTableAddConstraintOperation;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;

public abstract class AbstractAlterTableOperation<T extends AbstractAlterTableDesc>
extends DDLOperation<T> {
    protected EnvironmentContext environmentContext;

    public AbstractAlterTableOperation(DDLOperationContext context, T desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (!AlterTableUtils.allowOperationInReplicationScope(this.context.getDb(), ((AbstractAlterTableDesc)this.desc).getDbTableName(), null, ((AbstractAlterTableDesc)this.desc).getReplicationSpec())) {
            LOG.debug("DDLTask: Alter Table is skipped as table {} is newer than update", (Object)((AbstractAlterTableDesc)this.desc).getDbTableName());
            return 0;
        }
        Table oldTable = this.context.getDb().getTable(((AbstractAlterTableDesc)this.desc).getDbTableName());
        List<Partition> partitions = this.getPartitions(oldTable, ((AbstractAlterTableDesc)this.desc).getPartitionSpec(), this.context);
        Table table = oldTable.copy();
        this.environmentContext = this.initializeEnvironmentContext(oldTable, ((AbstractAlterTableDesc)this.desc).getEnvironmentContext());
        if (partitions == null) {
            this.doAlteration(table, null);
        } else {
            for (Partition partition : partitions) {
                this.doAlteration(table, partition);
            }
        }
        this.finalizeAlterTableWithWriteIdOp(table, oldTable, partitions, this.context, this.environmentContext);
        return 0;
    }

    private List<Partition> getPartitions(Table tbl, Map<String, String> partSpec, DDLOperationContext context) throws HiveException {
        List<Object> partitions = null;
        if (partSpec != null) {
            if (AlterTableUtils.isFullPartitionSpec(tbl, partSpec)) {
                partitions = new ArrayList();
                Partition part = context.getDb().getPartition(tbl, partSpec, false);
                if (part == null) {
                    throw new HiveException(ErrorMsg.INVALID_PARTITION, new String[]{StringUtils.join(partSpec.keySet(), (char)',') + " for table " + tbl.getTableName()});
                }
                partitions.add(part);
            } else {
                partitions = context.getDb().getPartitions(tbl, partSpec);
            }
        }
        return partitions;
    }

    private EnvironmentContext initializeEnvironmentContext(Table table, EnvironmentContext environmentContext) {
        HiveStorageHandler storageHandler;
        EnvironmentContext result;
        EnvironmentContext environmentContext2 = result = environmentContext == null ? new EnvironmentContext() : environmentContext;
        if (result.getProperties() == null || result.getProperties().get("DO_NOT_UPDATE_STATS") == null) {
            result.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        if ((storageHandler = table.getStorageHandler()) != null) {
            storageHandler.prepareAlterTableEnvironmentContext((AbstractAlterTableDesc)this.desc, result);
        }
        return result;
    }

    protected abstract void doAlteration(Table var1, Partition var2) throws HiveException;

    protected StorageDescriptor getStorageDescriptor(Table tbl, Partition part) {
        return part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
    }

    private void finalizeAlterTableWithWriteIdOp(Table table, Table oldTable, List<Partition> partitions, DDLOperationContext context, EnvironmentContext environmentContext) throws HiveException {
        if (partitions == null) {
            AbstractAlterTableOperation.updateModifiedParameters(table.getTTable().getParameters(), context.getConf());
            this.checkValidity(table, context);
        } else {
            for (Partition partition : partitions) {
                AbstractAlterTableOperation.updateModifiedParameters(partition.getParameters(), context.getConf());
            }
        }
        try {
            environmentContext.putToProperties("alterTableOpType", ((AbstractAlterTableDesc)this.desc).getType().name());
            if (((AbstractAlterTableDesc)this.desc).getType() == AlterTableType.ADDPROPS) {
                Map<String, String> oldTableParameters = oldTable.getParameters();
                environmentContext.putToProperties("set_properties", table.getParameters().entrySet().stream().filter(e -> !oldTableParameters.containsKey(e.getKey()) || !((String)oldTableParameters.get(e.getKey())).equals(e.getValue())).map(Map.Entry::getKey).collect(Collectors.joining("'")));
            } else if (((AbstractAlterTableDesc)this.desc).getType() == AlterTableType.DROPPROPS) {
                Map<String, String> newTableParameters = table.getParameters();
                environmentContext.putToProperties("unset_properties", oldTable.getParameters().entrySet().stream().filter(e -> !newTableParameters.containsKey(e.getKey())).map(Map.Entry::getKey).collect(Collectors.joining("'")));
            }
            if (partitions == null) {
                long writeId = ((AbstractAlterTableDesc)this.desc).getWriteId() != null ? ((AbstractAlterTableDesc)this.desc).getWriteId() : 0L;
                try {
                    context.getDb().alterTable(((AbstractAlterTableDesc)this.desc).getDbTableName(), table, ((AbstractAlterTableDesc)this.desc).isCascade(), environmentContext, true, writeId);
                }
                catch (HiveException ex) {
                    if (Boolean.valueOf(environmentContext.getProperties().getOrDefault("initialize_rollback_migration", "false")).booleanValue()) {
                        table.getSd().setInputFormat(oldTable.getSd().getInputFormat());
                        table.getSd().setOutputFormat(oldTable.getSd().getOutputFormat());
                        table.getSd().setSerdeInfo(oldTable.getSd().getSerdeInfo());
                        table.getSd().getCols().removeAll(oldTable.getPartitionKeys());
                        table.setPartCols(oldTable.getPartitionKeys());
                        table.getParameters().clear();
                        table.getParameters().putAll(oldTable.getParameters());
                        context.getDb().alterTable(((AbstractAlterTableDesc)this.desc).getDbTableName(), table, ((AbstractAlterTableDesc)this.desc).isCascade(), environmentContext, true, writeId);
                        throw new HiveException("Error occurred during hive table migration to iceberg. Table properties and serde info was reverted to its original value. Partition info was lost during the migration process, but it can be reverted by running MSCK REPAIR on table/partition level.\nRetrying the migration without issuing MSCK REPAIR on a partitioned table will result in an empty iceberg table.");
                    }
                    throw ex;
                }
            } else {
                boolean isTxn = false;
                if (((AbstractAlterTableDesc)this.desc).getPartitionSpec() != null && ((AbstractAlterTableDesc)this.desc).getType() == AlterTableType.ADDPROPS) {
                    Map<String, String> props = ((AbstractAlterTableDesc)this.desc).getProps();
                    isTxn = ((AbstractAlterTableDesc)this.desc).getReplicationSpec() != null && ((AbstractAlterTableDesc)this.desc).getReplicationSpec().isInReplicationScope() ? props.get("COLUMN_STATS_ACCURATE") != null : true;
                }
                String qualifiedName = TableName.getDbTable((String)table.getTTable().getDbName(), (String)table.getTTable().getTableName());
                context.getDb().alterPartitions(qualifiedName, partitions, environmentContext, isTxn);
            }
            if (this.desc instanceof AbstractAlterTableWithConstraintsDesc) {
                AlterTableAddConstraintOperation.addConstraints((AbstractAlterTableWithConstraintsDesc)this.desc, context.getDb());
            }
        }
        catch (InvalidOperationException e2) {
            LOG.error("alter table: ", (Throwable)e2);
            throw new HiveException((Throwable)e2, ErrorMsg.GENERIC_ERROR);
        }
        if (partitions != null) {
            for (Partition partition : partitions) {
                context.getWork().getInputs().add(new ReadEntity(partition));
                DDLUtils.addIfAbsentByName(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK), context);
            }
        } else {
            context.getWork().getInputs().add(new ReadEntity(oldTable));
            DDLUtils.addIfAbsentByName(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK), context);
        }
    }

    protected void checkValidity(Table table, DDLOperationContext context) throws HiveException {
        table.checkValidity((Configuration)context.getConf());
    }

    private static void updateModifiedParameters(Map<String, String> params, HiveConf conf) throws HiveException {
        String user = SessionState.getUserFromAuthenticator();
        params.put("last_modified_by", user);
        params.put("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
    }
}

