/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.status.formatter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.client.builder.GetPartitionProjectionsSpecBuilder;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.formatter.JsonShowTableStatusFormatter;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.formatter.TextShowTableStatusFormatter;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShowTableStatusFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(ShowTableStatusFormatter.class);

    public static ShowTableStatusFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonShowTableStatusFormatter();
        }
        return new TextShowTableStatusFormatter();
    }

    public abstract void showTableStatus(DataOutputStream var1, Hive var2, HiveConf var3, List<Table> var4, Partition var5) throws HiveException;

    StorageInfo getStorageInfo(Table table, Partition partition) throws HiveException {
        String location = null;
        String inputFormatClass = null;
        String outputFormatClass = null;
        if (partition != null) {
            if (partition.getLocation() != null) {
                location = partition.getDataLocation().toString();
            }
            inputFormatClass = partition.getInputFormatClass() == null ? null : partition.getInputFormatClass().getName();
            outputFormatClass = partition.getOutputFormatClass() == null ? null : partition.getOutputFormatClass().getName();
        } else {
            if (table.getPath() != null) {
                location = table.getDataLocation().toString();
            }
            inputFormatClass = table.getInputFormatClass() == null ? null : table.getInputFormatClass().getName();
            outputFormatClass = table.getOutputFormatClass() == null ? null : table.getOutputFormatClass().getName();
        }
        return new StorageInfo(location, inputFormatClass, outputFormatClass);
    }

    List<Path> getLocations(Hive db, Partition partition, Table table) throws HiveException {
        ArrayList<Path> locations = new ArrayList<Path>();
        if (table.isPartitioned()) {
            if (partition == null) {
                List<Partition> partitions;
                GetProjectionsSpec getProjectionsSpec = new GetPartitionProjectionsSpecBuilder().addProjectFieldList(Arrays.asList("sd.location")).build();
                GetPartitionsRequest request = new GetPartitionsRequest(table.getDbName(), table.getTableName(), getProjectionsSpec, null);
                request.setCatName(table.getCatName());
                try {
                    partitions = db.getPartitionsWithSpecs(table, request);
                }
                catch (Exception e) {
                    throw new HiveException((Throwable)e);
                }
                for (Partition currPartition : partitions) {
                    if (currPartition.getLocation() == null) continue;
                    locations.add(new Path(currPartition.getLocation()));
                }
            } else if (partition.getLocation() != null) {
                locations.add(new Path(partition.getLocation()));
            }
        } else if (table.getPath() != null) {
            locations.add(table.getPath());
        }
        return locations;
    }

    FileData getFileData(HiveConf conf, List<Path> locations, Path tablePath) throws IOException {
        FileData fileData = new FileData();
        FileSystem fileSystem = tablePath.getFileSystem((Configuration)conf);
        try {
            FileStatus tmpStatus = fileSystem.getFileStatus(tablePath);
            fileData.lastAccessTime = tmpStatus.getAccessTime();
            fileData.lastUpdateTime = tmpStatus.getModificationTime();
        }
        catch (IOException e) {
            LOG.warn("Cannot access File System. File System status will be unknown.", (Throwable)e);
            fileData.unknown = true;
        }
        if (!fileData.unknown) {
            for (Path location : locations) {
                try {
                    FileStatus status = fileSystem.getFileStatus(location);
                    if (!status.isDirectory()) continue;
                    this.processDir(status, fileSystem, fileData);
                }
                catch (IOException iOException) {}
            }
        }
        return fileData;
    }

    private void processDir(FileStatus status, FileSystem fileSystem, FileData fileData) throws IOException {
        FileStatus[] entryStatuses;
        fileData.lastAccessTime = Math.max(fileData.lastAccessTime, status.getAccessTime());
        fileData.lastUpdateTime = Math.max(fileData.lastUpdateTime, status.getModificationTime());
        for (FileStatus entryStatus : entryStatuses = fileSystem.listStatus(status.getPath())) {
            if (entryStatus.isDirectory()) {
                this.processDir(entryStatus, fileSystem, fileData);
                continue;
            }
            ++fileData.numOfFiles;
            if (entryStatus.isErasureCoded()) {
                ++fileData.numOfErasureCodedFiles;
            }
            long fileLength = entryStatus.getLen();
            fileData.totalFileSize += fileLength;
            fileData.maxFileSize = Math.max(fileData.maxFileSize, fileLength);
            fileData.minFileSize = Math.min(fileData.minFileSize, fileLength);
            fileData.lastAccessTime = Math.max(fileData.lastAccessTime, entryStatus.getAccessTime());
            fileData.lastUpdateTime = Math.max(fileData.lastUpdateTime, entryStatus.getModificationTime());
        }
    }

    static final class StorageInfo {
        final String location;
        final String inputFormatClass;
        final String outputFormatClass;

        private StorageInfo(String location, String inputFormatClass, String outputFormatClass) {
            this.location = location;
            this.inputFormatClass = inputFormatClass;
            this.outputFormatClass = outputFormatClass;
        }
    }

    static class FileData {
        boolean unknown = false;
        long totalFileSize = 0L;
        long maxFileSize = 0L;
        long minFileSize = Long.MAX_VALUE;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        int numOfFiles = 0;
        int numOfErasureCodedFiles = 0;

        FileData() {
        }

        long getMinFileSize() {
            return this.numOfFiles > 0 ? this.minFileSize : 0L;
        }
    }
}

