/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.view.create.AbstractCreateViewDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create View", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateViewDesc
extends AbstractCreateViewDesc {
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final Map<String, String> properties;
    private final List<String> partitionColumnNames;
    private final boolean ifNotExists;
    private final boolean replace;
    private final List<FieldSchema> partitionColumns;
    private ReplicationSpec replicationSpec = null;
    private String ownerName = null;

    public CreateViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> properties, List<String> partitionColumnNames, boolean ifNotExists, boolean replace, String originalText, String expandedText, List<FieldSchema> partitionColumns) {
        super(viewName, schema, originalText, expandedText);
        this.comment = comment;
        this.properties = properties;
        this.partitionColumnNames = partitionColumnNames;
        this.ifNotExists = ifNotExists;
        this.replace = replace;
        this.partitionColumns = partitionColumns;
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.partitionColumns);
    }

    public List<FieldSchema> getPartitionColumns() {
        return this.partitionColumns;
    }

    public List<String> getPartColNames() {
        return this.partitionColumnNames;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    @Explain(displayName="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Explain(displayName="replace", displayOnlyOnTrue=true)
    public boolean isReplace() {
        return this.replace;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }
}

