/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.show;

import java.io.DataOutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesFormatter;
import org.apache.hadoop.hive.ql.ddl.view.show.ShowViewsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFLike;

public class ShowViewsOperation
extends DDLOperation<ShowViewsDesc> {
    public ShowViewsOperation(DDLOperationContext context, ShowViewsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (!this.context.getDb().databaseExists(((ShowViewsDesc)this.desc).getDbName())) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, new String[]{((ShowViewsDesc)this.desc).getDbName()});
        }
        String pattern = UDFLike.likePatternToRegExp(((ShowViewsDesc)this.desc).getPattern(), false, true);
        List<String> viewNames = this.context.getDb().getTablesByType(((ShowViewsDesc)this.desc).getDbName(), pattern, TableType.VIRTUAL_VIEW);
        Collections.sort(viewNames);
        LOG.debug("Found {} view(s) matching the SHOW VIEWS statement.", (Object)viewNames.size());
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowViewsDesc)this.desc).getResFile()), this.context);){
            ShowTablesFormatter formatter = ShowTablesFormatter.getFormatter(this.context.getConf());
            formatter.showTables(os, viewNames);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"in database" + ((ShowViewsDesc)this.desc).getDbName()});
        }
        return 0;
    }
}

