/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public final class ArchiveUtils {
    public static final String ARCHIVING_LEVEL = "archiving_level";

    public static URI addSlash(URI u) throws HiveException {
        if (u.getPath().endsWith("/")) {
            return u;
        }
        try {
            return new URI(u.getScheme(), u.getAuthority(), u.getPath() + "/", u.getQuery(), u.getFragment());
        }
        catch (URISyntaxException e) {
            throw new HiveException("Could not append slash to a URI", (Throwable)e);
        }
    }

    public static boolean isArchived(Partition p) {
        return MetaStoreUtils.isArchived((org.apache.hadoop.hive.metastore.api.Partition)p.getTPartition());
    }

    public static int getArchivingLevel(Partition p) throws HiveException {
        try {
            return MetaStoreUtils.getArchivingLevel((org.apache.hadoop.hive.metastore.api.Partition)p.getTPartition());
        }
        catch (MetaException ex) {
            throw new HiveException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static String getPartialName(Partition p, int level) throws HiveException {
        List<FieldSchema> fields = p.getTable().getPartCols().subList(0, level);
        List<String> values = p.getValues().subList(0, level);
        try {
            return Warehouse.makePartName(fields, values);
        }
        catch (MetaException e) {
            throw new HiveException("Wasn't able to generate name for partial specification");
        }
    }

    public static String conflictingArchiveNameOrNull(Hive db, Table tbl, LinkedHashMap<String, String> partSpec) throws HiveException {
        List<FieldSchema> partKeys = tbl.getPartitionKeys();
        int partSpecLevel = 0;
        for (FieldSchema partKey : partKeys) {
            if (!partSpec.containsKey(partKey.getName())) break;
            ++partSpecLevel;
        }
        if (partSpecLevel != partSpec.size()) {
            throw new HiveException("partspec " + String.valueOf(partSpec) + " is wrong for table " + tbl.getTableName());
        }
        HashMap<String, String> spec = new HashMap<String, String>(partSpec);
        ArrayList<String> reversedKeys = new ArrayList<String>();
        for (FieldSchema fs : tbl.getPartCols()) {
            if (!spec.containsKey(fs.getName())) continue;
            reversedKeys.add(fs.getName());
        }
        Collections.reverse(reversedKeys);
        for (String rk : reversedKeys) {
            List<Partition> parts = db.getPartitions(tbl, spec, (short)1);
            if (parts.size() != 0) {
                Partition p = parts.get(0);
                if (!ArchiveUtils.isArchived(p)) {
                    return null;
                }
                if (ArchiveUtils.getArchivingLevel(p) > spec.size()) {
                    return null;
                }
                return ArchiveUtils.getPartialName(p, ArchiveUtils.getArchivingLevel(p));
            }
            spec.remove(rk);
        }
        return null;
    }

    public static class HarPathHelper {
        private final URI base;
        private final URI originalBase;

        public HarPathHelper(HiveConf hconf, URI archive, URI originalBase) throws HiveException {
            this.originalBase = ArchiveUtils.addSlash(originalBase);
            String parentHost = archive.getHost();
            Object harHost = archive.getScheme();
            harHost = parentHost == null ? (String)harHost + "-localhost" : (String)harHost + "-" + parentHost;
            String path = StringUtils.appendIfMissing((String)archive.getPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            if (!path.endsWith(".har/")) {
                throw new HiveException("HAR archive path must end with .har");
            }
            try {
                this.base = new URI("har", archive.getUserInfo(), (String)harHost, archive.getPort(), path, archive.getQuery(), archive.getFragment());
            }
            catch (URISyntaxException e) {
                throw new HiveException("Could not create har URI from archive URI", (Throwable)e);
            }
        }

        public URI getHarUri(URI original) throws URISyntaxException {
            URI relative = this.originalBase.relativize(original);
            if (relative.isAbsolute()) {
                throw new URISyntaxException("Could not create URI for location.", "Relative: " + String.valueOf(relative) + " Base: " + String.valueOf(this.base) + " OriginalBase: " + String.valueOf(this.originalBase));
            }
            return this.base.resolve(relative);
        }
    }

    public static class PartSpecInfo {
        public List<FieldSchema> fields;
        public List<String> values;

        private PartSpecInfo(List<FieldSchema> fields, List<String> values) {
            this.fields = fields;
            this.values = values;
        }

        public static PartSpecInfo create(Table tbl, Map<String, String> partSpec) throws HiveException {
            ArrayList<FieldSchema> prefixFields = new ArrayList<FieldSchema>();
            ArrayList<String> prefixValues = new ArrayList<String>();
            List<FieldSchema> partCols = tbl.getPartCols();
            Iterator<String> itrPsKeys = partSpec.keySet().iterator();
            for (FieldSchema fs : partCols) {
                if (!itrPsKeys.hasNext()) break;
                if (!itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) {
                    throw new HiveException("Invalid partition specification: " + String.valueOf(partSpec));
                }
                prefixFields.add(fs);
                prefixValues.add(partSpec.get(fs.getName()));
            }
            return new PartSpecInfo(prefixFields, prefixValues);
        }

        public Path createPath(Table tbl) throws HiveException {
            String prefixSubdir;
            try {
                prefixSubdir = Warehouse.makePartName(this.fields, this.values);
            }
            catch (MetaException e) {
                throw new HiveException("Unable to get partitions directories prefix", (Throwable)e);
            }
            Path tableDir = tbl.getDataLocation();
            if (tableDir == null) {
                throw new HiveException("Table has no location set");
            }
            return new Path(tableDir, prefixSubdir);
        }

        public String getName() throws HiveException {
            try {
                return Warehouse.makePartName(this.fields, this.values);
            }
            catch (MetaException e) {
                throw new HiveException("Unable to create partial name", (Throwable)e);
            }
        }
    }
}

