/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.FunctionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.CreateFunctionHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFunction {
    private static final Logger LOG = LoggerFactory.getLogger(LoadFunction.class);
    private Context context;
    private ReplLogger replLogger;
    private final FunctionEvent event;
    private final String dbNameToLoadIn;
    private final TaskTracker tracker;
    String dumpDirectory;
    private final ReplicationMetricCollector metricCollector;

    public LoadFunction(Context context, ReplLogger replLogger, FunctionEvent event, String dbNameToLoadIn, TaskTracker existingTracker, ReplicationMetricCollector metricCollector) {
        this.context = context;
        this.replLogger = replLogger;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(existingTracker);
        this.metricCollector = metricCollector;
    }

    public LoadFunction(Context context, ReplLogger replLogger, FunctionEvent event, String dbNameToLoadIn, TaskTracker existingTracker, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this.context = context;
        this.replLogger = replLogger;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(existingTracker);
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    private void createFunctionReplLogTask(List<Task<?>> functionTasks, String functionName) {
        ReplStateLogWork replLogWork = new ReplStateLogWork(this.replLogger, functionName, this.dumpDirectory, this.metricCollector);
        Task<ReplStateLogWork> replLogTask = TaskFactory.get(replLogWork, this.context.hiveConf);
        DAGTraversal.traverse(functionTasks, new AddDependencyToLeaves(replLogTask));
    }

    public TaskTracker tasks() throws IOException, SemanticException {
        URI fromURI = EximUtil.getValidatedURI(this.context.hiveConf, BaseSemanticAnalyzer.stripQuotes(this.event.rootDir().toUri().toString()));
        Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
        try {
            if (this.isFunctionAlreadyLoaded(fromPath)) {
                return this.tracker;
            }
            CreateFunctionHandler handler = new CreateFunctionHandler();
            List<Task<?>> tasks = handler.handle(new MessageHandler.Context(this.dbNameToLoadIn, fromPath.toString(), null, null, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG, this.dumpDirectory, this.metricCollector));
            this.createFunctionReplLogTask(tasks, handler.getFunctionName());
            tasks.forEach(this.tracker::addTask);
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), (Throwable)e);
        }
    }

    private boolean isFunctionAlreadyLoaded(Path funcDumpRoot) throws HiveException, IOException {
        Function function;
        Path metadataPath = new Path(funcDumpRoot, "_metadata");
        FileSystem fs = FileSystem.get((URI)metadataPath.toUri(), (Configuration)this.context.hiveConf);
        MetaData metadata = EximUtil.readMetaData(fs, metadataPath);
        try {
            String dbName = StringUtils.isBlank((CharSequence)this.dbNameToLoadIn) ? metadata.function.getDbName() : this.dbNameToLoadIn;
            function = this.context.hiveDb.getFunction(dbName, metadata.function.getFunctionName());
        }
        catch (HiveException e) {
            if (e.getCause() instanceof NoSuchObjectException) {
                return false;
            }
            throw e;
        }
        return function != null;
    }
}

