/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.AsyncPbRpcProxy;
import org.apache.hadoop.hive.llap.LlapNodeId;
import org.apache.hadoop.hive.llap.impl.LlapPluginProtocolClientImpl;
import org.apache.hadoop.hive.llap.plugin.rpc.LlapPluginProtocolProtos;
import org.apache.hadoop.hive.llap.protocol.LlapPluginProtocolPB;
import org.apache.hadoop.hive.ql.exec.tez.AmPluginNode;
import org.apache.hadoop.hive.ql.exec.tez.LlapPluginEndpointClient;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.common.util.Ref;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapPluginEndpointClientImpl
extends AsyncPbRpcProxy<LlapPluginProtocolPB, JobTokenIdentifier>
implements LlapPluginEndpointClient {
    private static final Logger LOG = LoggerFactory.getLogger(LlapPluginEndpointClientImpl.class);

    public LlapPluginEndpointClientImpl(Configuration conf, Token<JobTokenIdentifier> token, int expectedNodes) {
        super(LlapPluginEndpointClientImpl.class.getSimpleName(), HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_PLUGIN_CLIENT_NUM_THREADS), conf, token, HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_COMMUNICATOR_CONNECTION_TIMEOUT_MS, (TimeUnit)TimeUnit.MILLISECONDS), HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_COMMUNICATOR_CONNECTION_SLEEP_BETWEEN_RETRIES_MS, (TimeUnit)TimeUnit.MILLISECONDS), expectedNodes, 1);
    }

    protected LlapPluginProtocolPB createProtocolImpl(Configuration conf, String hostname, int port, UserGroupInformation ugi, RetryPolicy retryPolicy, SocketFactory socketFactory) {
        return new LlapPluginProtocolClientImpl(conf, hostname, port, retryPolicy, socketFactory, ugi);
    }

    protected void shutdownProtocolImpl(LlapPluginProtocolPB proxy) {
    }

    protected String getTokenUser(Token<JobTokenIdentifier> token) {
        try {
            JobTokenIdentifier id = (JobTokenIdentifier)token.decodeIdentifier();
            if (id == null) {
                LOG.warn("Token ID is null from " + String.valueOf(token));
                return null;
            }
            if (id.getJobId() == null) {
                LOG.warn("Job ID is null from " + String.valueOf(id));
                return null;
            }
            return id.getJobId().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendUpdateQuery(LlapPluginProtocolProtos.UpdateQueryRequestProto request, AmPluginNode node, LlapPluginEndpointClient.UpdateRequestContext callback) {
        this.queueRequest(new SendUpdateQueryCallable(node, request, callback));
    }

    private class SendUpdateQueryCallable
    extends AsyncPbRpcProxy.CallableRequest<LlapPluginProtocolProtos.UpdateQueryRequestProto, LlapPluginProtocolProtos.UpdateQueryResponseProto> {
        private final AmPluginNode node;
        private AmPluginNode.AmPluginInfo info;
        private final LlapPluginEndpointClient.UpdateRequestContext context;

        protected SendUpdateQueryCallable(AmPluginNode node, LlapPluginProtocolProtos.UpdateQueryRequestProto request, LlapPluginEndpointClient.UpdateRequestContext callback) {
            super((Message)request, (AsyncPbRpcProxy.ExecuteRequestCallback)callback);
            this.node = node;
            this.context = callback;
        }

        public LlapNodeId getNodeId() throws InterruptedException, TimeoutException {
            this.ensureInfo();
            return LlapNodeId.getInstance((String)this.info.amHost, (int)this.info.amPluginPort);
        }

        public LlapPluginProtocolProtos.UpdateQueryResponseProto call() throws Exception {
            this.ensureInfo();
            LlapNodeId nodeId = LlapNodeId.getInstance((String)this.info.amHost, (int)this.info.amPluginPort);
            return ((LlapPluginProtocolPB)LlapPluginEndpointClientImpl.this.getProxy(nodeId, this.info.amPluginToken)).updateQuery(null, (LlapPluginProtocolProtos.UpdateQueryRequestProto)this.request);
        }

        private void ensureInfo() {
            if (this.info != null) {
                return;
            }
            Ref endpointVersion = new Ref((Object)-1);
            this.info = this.node.getAmPluginInfo((Ref<Integer>)endpointVersion);
            this.context.setNodeInfo(this.info, (Integer)endpointVersion.value);
            if (this.info == null) {
                throw new RuntimeException("No AM plugin info for " + String.valueOf(this.node));
            }
        }
    }
}

