/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.registry.ServiceInstanceStateChangeListener;
import org.apache.hadoop.hive.registry.impl.TezAmInstance;
import org.apache.hadoop.hive.registry.impl.TezAmRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TezSessionPool<SessionType extends TezSessionPoolSession> {
    private static final Logger LOG = LoggerFactory.getLogger(TezSessionPool.class);
    private final int initialSize;
    private final SessionObjectFactory<SessionType> sessionObjFactory;
    private final ReentrantLock poolLock = new ReentrantLock(true);
    private final Condition notEmpty = this.poolLock.newCondition();
    private final LinkedList<SessionType> pool = new LinkedList();
    private final LinkedList<SettableFuture<SessionType>> asyncRequests = new LinkedList();
    private final AtomicInteger deltaRemaining;
    private final String amRegistryName;
    private final TezAmRegistryImpl amRegistry;
    private final ListeningExecutorService executorService;
    private final ConcurrentHashMap<String, SessionType> bySessionId = new ConcurrentHashMap();
    private SessionState parentSessionState;

    TezSessionPool(HiveConf initConf, int numSessionsTotal, boolean useAmRegistryIfPresent, SessionObjectFactory<SessionType> sessionFactory) {
        Objects.requireNonNull(initConf);
        this.initialSize = numSessionsTotal;
        this.amRegistry = useAmRegistryIfPresent ? TezAmRegistryImpl.create((Configuration)initConf, (boolean)true) : null;
        this.amRegistryName = this.amRegistry == null ? null : this.amRegistry.getRegistryName();
        this.sessionObjFactory = sessionFactory;
        this.deltaRemaining = new AtomicInteger(this.initialSize);
        int threadCount = HiveConf.getIntVar((Configuration)initConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_MAX_INIT_THREADS);
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(0, threadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("tez-session-init-%d").build()));
    }

    void start() throws Exception {
        if (this.amRegistry != null) {
            this.amRegistry.start();
            this.amRegistry.initializeWithoutRegistering();
            this.amRegistry.registerStateChangeListener((ServiceInstanceStateChangeListener)new ChangeListener());
            this.amRegistry.populateCache(true);
        }
        this.parentSessionState = SessionState.get();
        if (this.initialSize == 0) {
            return;
        }
        this.createSessions(this.initialSize).get();
    }

    SessionType getSession() throws Exception {
        while (true) {
            TezSessionPoolSession result = null;
            this.poolLock.lock();
            try {
                while ((result = (TezSessionPoolSession)this.pool.poll()) == null) {
                    LOG.info("Awaiting Tez session to become available in session pool");
                    this.notEmpty.await(10L, TimeUnit.SECONDS);
                }
            }
            finally {
                this.poolLock.unlock();
            }
            if (result.tryUse(false)) {
                return (SessionType)result;
            }
            LOG.info("Failed to use a session [" + String.valueOf(result) + "]; attempting another one");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<SessionType> getSessionAsync() throws Exception {
        SettableFuture future = SettableFuture.create();
        this.poolLock.lock();
        try {
            TezSessionPoolSession result;
            while ((result = (TezSessionPoolSession)this.pool.poll()) != null) {
                if (!result.tryUse(false)) continue;
                future.set((Object)result);
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            this.asyncRequests.add(future);
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    void returnSession(SessionType session) {
        this.returnSessionInternal(session, false);
    }

    boolean returnSessionAsync(SessionType session) {
        return this.returnSessionInternal(session, true);
    }

    private boolean returnSessionInternal(SessionType session, boolean isAsync) {
        SessionState sessionState = SessionState.get();
        if (sessionState != null) {
            sessionState.setTezSession(null);
        }
        if (!((TezSessionPoolSession)session).stopUsing()) {
            return true;
        }
        boolean canPutBack = this.putSessionBack(session, true);
        if (canPutBack) {
            return true;
        }
        LOG.debug("Closing an unneeded returned session {}", session);
        if (isAsync) {
            return false;
        }
        try {
            ((TezSessionPoolSession)session).close(false);
        }
        catch (Exception ex) {
            LOG.error("Failed to close " + String.valueOf(session), (Throwable)ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSessionBack(SessionType session, boolean isFirst) {
        SettableFuture<SessionType> future = null;
        this.poolLock.lock();
        try {
            int remainingToKill;
            while ((remainingToKill = -this.deltaRemaining.get()) > 0) {
                if (!this.deltaRemaining.compareAndSet(-remainingToKill, -remainingToKill + 1)) continue;
                boolean bl = false;
                return bl;
            }
            if (!this.asyncRequests.isEmpty()) {
                if (!((TezSessionPoolSession)session).tryUse(false)) {
                    boolean bl = true;
                    return bl;
                }
                future = this.asyncRequests.poll();
            }
            if (future == null) {
                if (isFirst) {
                    this.pool.addFirst(session);
                } else {
                    this.pool.addLast(session);
                }
                this.notEmpty.signalAll();
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (future != null) {
            future.set(session);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceSession(SessionType oldSession) throws Exception {
        TezSessionPoolSession newSession = (TezSessionPoolSession)this.sessionObjFactory.create(oldSession);
        String queueName = ((TezSessionState)oldSession).getQueueName();
        try {
            ((TezSessionPoolSession)oldSession).close(false);
        }
        finally {
            this.poolLock.lock();
            try {
                this.pool.remove(oldSession);
            }
            finally {
                this.poolLock.unlock();
            }
            this.notifyClosed((TezSessionState)oldSession);
            newSession.getConf().set("tez.queue.name", queueName);
            this.configureAmRegistry(newSession);
            if (SessionState.get() == null && this.parentSessionState != null) {
                SessionState.setCurrentSessionState(this.parentSessionState);
            }
            newSession.open();
            if (!this.putSessionBack(newSession, false)) {
                LOG.debug("Closing an unneeded session {}; trying to replace {}", (Object)newSession, oldSession);
                try {
                    newSession.close(false);
                }
                catch (Exception ex) {
                    LOG.error("Failed to close an unneeded session", (Throwable)ex);
                }
            }
        }
    }

    private void startInitialSession(SessionType session) throws Exception {
        boolean isUsable = ((TezSessionPoolSession)session).tryUse(true);
        if (!isUsable) {
            throw new IOException(String.valueOf(session) + " is not usable at pool startup");
        }
        ((TezSessionState)session).getConf().set("tez.queue.name", ((TezSessionState)session).getQueueName());
        this.configureAmRegistry(session);
        ((TezSessionState)session).open();
        if (((TezSessionPoolSession)session).stopUsing() && !this.putSessionBack(session, false)) {
            LOG.warn("Couldn't add a session during initialization");
            try {
                ((TezSessionPoolSession)session).close(false);
            }
            catch (Exception ex) {
                LOG.error("Failed to close an unneeded session", (Throwable)ex);
            }
        }
    }

    private void configureAmRegistry(SessionType session) {
        if (this.amRegistryName != null) {
            this.bySessionId.put(((TezSessionState)session).getSessionId(), session);
            HiveConf conf = ((TezSessionState)session).getConf();
            conf.set(HiveConf.ConfVars.LLAP_TASK_SCHEDULER_AM_REGISTRY_NAME.varname, this.amRegistryName);
            conf.set(HiveConf.ConfVars.HIVE_SESSION_ID.varname, ((TezSessionState)session).getSessionId());
        }
    }

    @VisibleForTesting
    int getInitialSize() {
        return this.initialSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> resizeAsync(int delta, List<SessionType> toClose) {
        if (delta == 0) {
            return this.createDummyFuture();
        }
        this.poolLock.lock();
        try {
            if (delta < 0) {
                ListenableFuture<Boolean> listenableFuture = this.resizeDownInternal(-delta, toClose);
                return listenableFuture;
            }
            ListenableFuture<?> listenableFuture = this.resizeUpInternal(delta);
            return listenableFuture;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    private ListenableFuture<?> resizeUpInternal(int delta) {
        int oldVal;
        while (!this.deltaRemaining.compareAndSet(oldVal = this.deltaRemaining.get(), oldVal + delta)) {
        }
        int toStart = oldVal + delta;
        if (toStart <= 0) {
            return this.createDummyFuture();
        }
        LOG.info("Resizing the pool; adding {} sessions", (Object)toStart);
        return this.createSessions(toStart);
    }

    private ListenableFuture<List<Boolean>> createSessions(int sessionCount) {
        Preconditions.checkArgument((sessionCount > 0 ? 1 : 0) != 0);
        Collection tasks = Stream.generate(() -> new CreateSessionCallable(Optional.ofNullable(this.parentSessionState), this.sessionObjFactory, this.deltaRemaining)).limit(sessionCount).collect(Collectors.toList());
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(tasks.size());
        for (Callable task : tasks) {
            futures.add(this.executorService.submit(task));
        }
        return Futures.allAsList(futures);
    }

    private ListenableFuture<Boolean> resizeDownInternal(int delta, List<SessionType> toClose) {
        TezSessionPoolSession session;
        int expansionCount;
        while ((expansionCount = this.deltaRemaining.get()) > 0) {
            int expansionCancelled = Math.min(expansionCount, delta);
            if (!this.deltaRemaining.compareAndSet(expansionCount, expansionCount - expansionCancelled)) continue;
            delta -= expansionCancelled;
            break;
        }
        while (delta > 0 && (session = (TezSessionPoolSession)this.pool.poll()) != null) {
            if (!session.tryUse(true)) continue;
            toClose.add(session);
            --delta;
        }
        if (delta > 0) {
            int oldVal;
            while (!this.deltaRemaining.compareAndSet(oldVal = this.deltaRemaining.get(), oldVal - delta)) {
            }
        }
        return this.createDummyFuture();
    }

    private ListenableFuture<Boolean> createDummyFuture() {
        SettableFuture f = SettableFuture.create();
        f.set((Object)true);
        return f;
    }

    @VisibleForTesting
    int getCurrentSize() {
        this.poolLock.lock();
        try {
            int n = this.pool.size();
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public void notifyClosed(TezSessionState session) {
        this.bySessionId.remove(session.getSessionId());
    }

    public static interface SessionObjectFactory<SessionType> {
        public SessionType create(SessionType var1);
    }

    private final class ChangeListener
    implements ServiceInstanceStateChangeListener<TezAmInstance> {
        private ChangeListener() {
        }

        public void onCreate(TezAmInstance si, int ephSeqVersion) {
            String sessionId = si.getSessionId();
            TezSessionPoolSession session = (TezSessionPoolSession)TezSessionPool.this.bySessionId.get(sessionId);
            if (session != null) {
                LOG.info("AM for " + sessionId + ", v." + ephSeqVersion + " has registered; updating [" + String.valueOf(session) + "] with an endpoint at " + si.getPluginPort());
                session.updateFromRegistry(si, ephSeqVersion);
            } else {
                LOG.warn("AM for an unknown " + sessionId + " has registered; ignoring");
            }
        }

        public void onUpdate(TezAmInstance si, int ephSeqVersion) {
            String sessionId = si.getSessionId();
            TezSessionPoolSession session = (TezSessionPoolSession)TezSessionPool.this.bySessionId.get(sessionId);
            if (session != null) {
                LOG.info("AM for " + sessionId + ", v." + ephSeqVersion + " has updated; updating [" + String.valueOf(session) + "] with an endpoint at " + si.getPluginPort());
                session.updateFromRegistry(si, ephSeqVersion);
            } else {
                LOG.warn("AM for an unknown " + sessionId + " has updated; ignoring");
            }
        }

        public void onRemove(TezAmInstance serviceInstance, int ephSeqVersion) {
            String sessionId = serviceInstance.getSessionId();
            TezSessionPoolSession session = (TezSessionPoolSession)TezSessionPool.this.bySessionId.get(sessionId);
            if (session != null) {
                LOG.info("AM for " + sessionId + ", v." + ephSeqVersion + " has unregistered; updating [" + String.valueOf(session) + "]");
                session.updateFromRegistry(null, ephSeqVersion);
            } else {
                LOG.warn("AM for an unknown " + sessionId + " has unregistered; ignoring");
            }
        }
    }

    private final class CreateSessionCallable
    implements Callable<Boolean> {
        private final Optional<SessionState> sessionState;
        private final SessionObjectFactory<SessionType> sessionObjFactory;
        private final AtomicInteger backlog;

        private CreateSessionCallable(Optional<SessionState> sessionState, SessionObjectFactory<SessionType> sessionObjFactory, AtomicInteger backlog) {
            this.sessionState = Objects.requireNonNull(sessionState);
            this.sessionObjFactory = Objects.requireNonNull(sessionObjFactory);
            this.backlog = Objects.requireNonNull(backlog);
        }

        @Override
        public Boolean call() throws Exception {
            if (this.sessionState.isPresent()) {
                SessionState.setCurrentSessionState(this.sessionState.get());
            }
            int oldVal;
            while ((oldVal = this.backlog.get()) > 0) {
                if (!this.backlog.compareAndSet(oldVal, oldVal - 1)) continue;
                TezSessionPool.this.startInitialSession(this.sessionObjFactory.create(null));
            }
            return true;
        }
    }
}

