/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncDoubleToDouble;

public class FuncLogWithBaseDoubleToDouble
extends MathFuncDoubleToDouble {
    private static final long serialVersionUID = 1L;
    private final double base;

    public FuncLogWithBaseDoubleToDouble(double scalarVal, int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.base = scalarVal;
    }

    public FuncLogWithBaseDoubleToDouble() {
        this.base = 0.0;
    }

    @Override
    protected double func(double d) {
        return StrictMath.log(d) / StrictMath.log(this.base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

