/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprCondExprBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprColumnCondExpr
extends IfExprCondExprBase {
    private static final long serialVersionUID = 1L;

    public IfExprColumnCondExpr(int arg1Column, int arg2Column, int arg3Column, int outputColumnNum) {
        super(arg1Column, arg2Column, arg3Column, outputColumnNum);
    }

    public IfExprColumnCondExpr() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int batchIndex;
        int i;
        int n = batch.size;
        if (n <= 0) {
            return;
        }
        super.evaluate(batch);
        ColumnVector outputColVector = batch.cols[this.outputColumnNum];
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        outputColVector.init();
        ColumnVector thenColVector = batch.cols[this.inputColumnNum[1]];
        ColumnVector elseColVector = batch.cols[this.inputColumnNum[2]];
        int thenCount = this.thenSelectedCount;
        int elseCount = this.elseSelectedCount;
        if (this.isIfStatementResultRepeated) {
            if (this.isIfStatementResultThen) {
                this.childExpressions[1].evaluate(batch);
                thenColVector.copySelected(batch.selectedInUse, batch.selected, n, outputColVector);
            } else {
                this.childExpressions[2].evaluate(batch);
                elseColVector.copySelected(batch.selectedInUse, batch.selected, n, outputColVector);
            }
            return;
        }
        this.childExpressions[1].evaluate(batch);
        this.conditionalEvaluate(batch, this.childExpressions[2], this.elseSelected, elseCount);
        for (i = 0; i < thenCount; ++i) {
            batchIndex = this.thenSelected[i];
            outputIsNull[batchIndex] = false;
            outputColVector.setElement(batchIndex, batchIndex, thenColVector);
        }
        for (i = 0; i < elseCount; ++i) {
            batchIndex = this.elseSelected[i];
            outputIsNull[batchIndex] = false;
            outputColVector.setElement(batchIndex, batchIndex, elseColVector);
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]) + this.getColumnParamString(2, this.inputColumnNum[2]);
    }
}

