/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncTimestampToTimestamp;

public class VectorUDFDatetimeLegacyHybridCalendarTimestamp
extends FuncTimestampToTimestamp {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter.setLenient(false);
        return formatter;
    });

    public VectorUDFDatetimeLegacyHybridCalendarTimestamp() {
    }

    public VectorUDFDatetimeLegacyHybridCalendarTimestamp(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    @Override
    protected void func(TimestampColumnVector outputColVector, TimestampColumnVector inputColVector, int i) {
        String adjustedTimestampString = SIMPLE_DATE_FORMAT_THREAD_LOCAL.get().format(new Timestamp(inputColVector.time[i]));
        org.apache.hadoop.hive.common.type.Timestamp adjustedTimestamp = org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)adjustedTimestampString);
        outputColVector.time[i] = adjustedTimestamp.toEpochMilli();
        outputColVector.nanos[i] = inputColVector.nanos[i];
    }
}

