/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseCol;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorUDFMapIndexDecimalCol
extends VectorUDFMapIndexBaseCol {
    public VectorUDFMapIndexDecimalCol() {
    }

    public VectorUDFMapIndexDecimalCol(int mapColumnNum, int indexColumnNum, int outputColumnNum) {
        super(mapColumnNum, indexColumnNum, outputColumnNum);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + this.getColumnParamString(1, this.getIndexColumnNum());
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.DECIMAL).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }

    @Override
    public int findInMap(ColumnVector indexColumnVector, int indexBatchIndex, MapColumnVector mapColumnVector, int mapBatchIndex) {
        int offset = (int)mapColumnVector.offsets[mapBatchIndex];
        int count = (int)mapColumnVector.lengths[mapBatchIndex];
        HiveDecimalWritable[] keys = ((DecimalColumnVector)mapColumnVector.keys).vector;
        HiveDecimalWritable index = ((DecimalColumnVector)indexColumnVector).vector[indexBatchIndex];
        for (int i = 0; i < count; ++i) {
            if (index.compareTo(keys[offset + i]) != 0) continue;
            return offset + i;
        }
        return -1;
    }
}

