/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldDate;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public final class VectorUDFUnixTimeStampDate
extends VectorUDFTimestampFieldDate {
    private static final long serialVersionUID = 1L;
    private Date date;
    private ZoneId timeZone;

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        if (this.timeZone == null) {
            String timeZoneStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE);
            this.timeZone = TimestampTZUtil.parseTimeZone((String)timeZoneStr);
        }
    }

    @Override
    protected long getDateField(long days) {
        this.date.setTimeInDays((int)days);
        return TimestampTZUtil.convert((Date)this.date, (ZoneId)this.timeZone).getEpochSecond();
    }

    public VectorUDFUnixTimeStampDate(int colNum, int outputColumnNum) {
        super(-1, colNum, outputColumnNum);
        this.date = new Date();
    }

    public VectorUDFUnixTimeStampDate() {
    }
}

