/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinInnerGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinInnerGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashMapResult[] hashMapResults;
    protected transient int[] allMatches;
    protected transient int[] equalKeySeriesHashMapResultIndices;
    protected transient int[] equalKeySeriesAllMatchIndices;
    protected transient boolean[] equalKeySeriesIsSingleValue;
    protected transient int[] equalKeySeriesDuplicateCounts;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;

    protected VectorMapJoinInnerGenerateResultOperator() {
    }

    public VectorMapJoinInnerGenerateResultOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinInnerGenerateResultOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    protected void commonSetup() throws HiveException {
        super.commonSetup();
        VectorMapJoinHashMap baseHashMap = (VectorMapJoinHashMap)this.vectorMapJoinHashTable;
        this.hashMapResults = new VectorMapJoinHashMapResult[1024];
        for (int i = 0; i < this.hashMapResults.length; ++i) {
            this.hashMapResults[i] = baseHashMap.createHashMapResult();
        }
        this.allMatches = new int[1024];
        this.equalKeySeriesHashMapResultIndices = new int[1024];
        this.equalKeySeriesAllMatchIndices = new int[1024];
        this.equalKeySeriesIsSingleValue = new boolean[1024];
        this.equalKeySeriesDuplicateCounts = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
    }

    protected void innerPerBatchSetup(VectorizedRowBatch batch) {
        for (int column : this.smallTableValueColumnMap) {
            ColumnVector smallTableColumn = batch.cols[column];
            smallTableColumn.reset();
        }
    }

    protected void finishInner(VectorizedRowBatch batch, int allMatchCount, int equalKeySeriesCount, int spillCount, int hashMapResultCount) throws HiveException, IOException {
        int numSel = 0;
        if (allMatchCount > 0 && this.bigTableValueExpressions != null) {
            this.performValueExpressions(batch, this.allMatches, allMatchCount);
        }
        for (int i = 0; i < equalKeySeriesCount; ++i) {
            int hashMapResultIndex = this.equalKeySeriesHashMapResultIndices[i];
            VectorMapJoinHashMapResult hashMapResult = this.hashMapResults[hashMapResultIndex];
            int allMatchesIndex = this.equalKeySeriesAllMatchIndices[i];
            boolean isSingleValue = this.equalKeySeriesIsSingleValue[i];
            int duplicateCount = this.equalKeySeriesDuplicateCounts[i];
            if (isSingleValue) {
                numSel = this.generateHashMapResultSingleValue(batch, hashMapResult, this.allMatches, allMatchesIndex, duplicateCount, numSel);
                continue;
            }
            this.generateHashMapResultMultiValue(batch, hashMapResult, this.allMatches, allMatchesIndex, duplicateCount);
        }
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, this.hashMapResults, this.spills, this.spillHashMapResultIndices, spillCount);
        }
        batch.size = numSel;
        batch.selectedInUse = true;
    }

    protected void finishInnerRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashTableResult hashMapResult) throws HiveException, IOException {
        boolean numSel = false;
        switch (joinResult) {
            case MATCH: {
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                this.generateHashMapResultRepeatedAll(batch, this.hashMapResults[0]);
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, this.hashMapResults[0]);
                batch.size = 0;
                break;
            }
            case NOMATCH: {
                batch.size = 0;
            }
        }
    }
}

