/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashKeyRef;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.serde2.WriteBuffers;

public class VectorMapJoinFastBytesHashSetStore
implements MemoryEstimate {
    private WriteBuffers writeBuffers;

    public WriteBuffers getWriteBuffers() {
        return this.writeBuffers;
    }

    public long add(long partialHashCode, byte[] keyBytes, int keyStart, int keyLength) {
        boolean isKeyLengthBig;
        long absoluteOffset = this.writeBuffers.getWritePoint();
        boolean bl = isKeyLengthBig = keyLength >= 255;
        if (isKeyLengthBig) {
            this.writeBuffers.writeVInt(keyLength);
        }
        this.writeBuffers.write(keyBytes, keyStart, keyLength);
        long refWord = partialHashCode;
        refWord |= absoluteOffset << 15;
        refWord = isKeyLengthBig ? (refWord |= 0x3FC0000000000000L) : (refWord |= (long)keyLength << 54);
        return refWord |= 0x4000000000000000L;
    }

    public VectorMapJoinFastBytesHashSetStore(int writeBuffersSize) {
        this.writeBuffers = new WriteBuffers(writeBuffersSize, 0x2000000000L);
    }

    public long getEstimatedMemorySize() {
        long size = 0L;
        return size += this.writeBuffers == null ? 0L : this.writeBuffers.getEstimatedMemorySize();
    }

    public static class HashSetResult
    extends VectorMapJoinHashSetResult {
        private VectorMapJoinFastBytesHashSetStore setStore;
        private int keyLength;
        private long absoluteOffset;
        private WriteBuffers.Position readPos = new WriteBuffers.Position();

        public void setKey(VectorMapJoinFastBytesHashSetStore setStore, long refWord) {
            boolean isKeyLengthSmall;
            this.setStore = setStore;
            this.absoluteOffset = VectorMapJoinFastBytesHashKeyRef.KeyRef.getAbsoluteOffset(refWord);
            setStore.writeBuffers.setReadPoint(this.absoluteOffset, this.readPos);
            this.keyLength = VectorMapJoinFastBytesHashKeyRef.KeyRef.getSmallKeyLength(refWord);
            boolean bl = isKeyLengthSmall = this.keyLength != 255;
            if (!isKeyLengthSmall) {
                this.keyLength = setStore.writeBuffers.readVInt(this.readPos);
            }
        }

        public boolean equalKey(byte[] keyBytes, int keyStart, int keyLength) {
            if (this.keyLength != keyLength) {
                return false;
            }
            return this.setStore.writeBuffers.isEqual(keyBytes, keyStart, this.readPos, keyLength);
        }

        public void setContains() {
            this.setJoinResult(JoinUtil.JoinResult.MATCH);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            return sb.toString();
        }
    }
}

