/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorHelper {
    public static Long computeValue(Long number) {
        return number == null ? 0L : number;
    }

    public static Long plus(Long l1, Long l2) {
        return l1 + l2;
    }

    public static Long minus(Long l1, Long l2) {
        return l1 - l2;
    }

    public static Double divide(Long number, long divisor) {
        if (divisor == 0L) {
            return null;
        }
        return (double)number.longValue() / (double)divisor;
    }

    public static Double computeValue(Double number) {
        return number == null ? 0.0 : number;
    }

    public static Double plus(Double d1, Double d2) {
        return d1 + d2;
    }

    public static Double minus(Double d1, Double d2) {
        return d1 - d2;
    }

    public static Double divide(Double number, long divisor) {
        if (divisor == 0L) {
            return null;
        }
        return number / (double)divisor;
    }

    public static HiveDecimalWritable computeValue(HiveDecimalWritable number) {
        return number == null ? new HiveDecimalWritable(0L) : new HiveDecimalWritable(number.isSet() ? number : new HiveDecimalWritable(0L));
    }

    public static HiveDecimalWritable plus(HiveDecimalWritable t1, HiveDecimalWritable t2) {
        HiveDecimalWritable result = new HiveDecimalWritable(t1);
        result.mutateAdd(t2);
        return result;
    }

    public static HiveDecimalWritable minus(HiveDecimalWritable t1, HiveDecimalWritable t2) {
        HiveDecimalWritable result = new HiveDecimalWritable(t2);
        result.mutateNegate();
        result.mutateAdd(t1);
        return result;
    }

    public static HiveDecimalWritable divide(HiveDecimalWritable number, long divisor) {
        if (number == null || divisor == 0L) {
            return null;
        }
        HiveDecimalWritable result = new HiveDecimalWritable(number);
        result.mutateDivide(HiveDecimal.create((long)divisor));
        return result;
    }
}

