/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.wrapper;

import com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSetInfo;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBase;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hive.common.util.Murmur3;

public class VectorHashKeyWrapperGeneral
extends VectorHashKeyWrapperBase {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final byte[][] EMPTY_BYTES_ARRAY = new byte[0][];
    private static final HiveDecimalWritable[] EMPTY_DECIMAL_ARRAY = new HiveDecimalWritable[0];
    private static final Timestamp[] EMPTY_TIMESTAMP_ARRAY = new Timestamp[0];
    private static final HiveIntervalDayTime[] EMPTY_INTERVAL_DAY_TIME_ARRAY = new HiveIntervalDayTime[0];
    private long[] longValues;
    private double[] doubleValues;
    private byte[][] byteValues;
    private int[] byteStarts;
    private int[] byteLengths;
    private HiveDecimalWritable[] decimalValues;
    private Timestamp[] timestampValues;
    private static Timestamp ZERO_TIMESTAMP = new Timestamp(0L);
    private HiveIntervalDayTime[] intervalDayTimeValues;
    private static HiveIntervalDayTime ZERO_INTERVALDAYTIME = new HiveIntervalDayTime(0L, 0);
    private VectorHashKeyWrapperBase.HashContext hashCtx;
    private int keyCount;
    protected boolean[] isNull;

    public VectorHashKeyWrapperGeneral(VectorHashKeyWrapperBase.HashContext ctx, int longValuesCount, int doubleValuesCount, int byteValuesCount, int decimalValuesCount, int timestampValuesCount, int intervalDayTimeValuesCount, int keyCount) {
        int i;
        this.hashCtx = ctx;
        this.keyCount = keyCount;
        this.longValues = longValuesCount > 0 ? new long[longValuesCount] : EMPTY_LONG_ARRAY;
        this.doubleValues = doubleValuesCount > 0 ? new double[doubleValuesCount] : EMPTY_DOUBLE_ARRAY;
        this.decimalValues = decimalValuesCount > 0 ? new HiveDecimalWritable[decimalValuesCount] : EMPTY_DECIMAL_ARRAY;
        this.timestampValues = timestampValuesCount > 0 ? new Timestamp[timestampValuesCount] : EMPTY_TIMESTAMP_ARRAY;
        this.intervalDayTimeValues = intervalDayTimeValuesCount > 0 ? new HiveIntervalDayTime[intervalDayTimeValuesCount] : EMPTY_INTERVAL_DAY_TIME_ARRAY;
        for (i = 0; i < decimalValuesCount; ++i) {
            this.decimalValues[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
        if (byteValuesCount > 0) {
            this.byteValues = new byte[byteValuesCount][];
            this.byteStarts = new int[byteValuesCount];
            this.byteLengths = new int[byteValuesCount];
        } else {
            this.byteValues = EMPTY_BYTES_ARRAY;
            this.byteStarts = EMPTY_INT_ARRAY;
            this.byteLengths = EMPTY_INT_ARRAY;
        }
        for (i = 0; i < timestampValuesCount; ++i) {
            this.timestampValues[i] = new Timestamp(0L);
        }
        for (i = 0; i < intervalDayTimeValuesCount; ++i) {
            this.intervalDayTimeValues[i] = new HiveIntervalDayTime();
        }
        this.isNull = new boolean[keyCount];
    }

    private VectorHashKeyWrapperGeneral() {
    }

    @Override
    public void setHashKey() {
        int i;
        int hash = Arrays.hashCode(this.longValues) ^ Arrays.hashCode(this.doubleValues) ^ Arrays.hashCode(this.isNull);
        for (i = 0; i < this.decimalValues.length; ++i) {
            hash ^= this.decimalValues[i].newFasterHashCode();
        }
        for (i = 0; i < this.timestampValues.length; ++i) {
            hash ^= this.timestampValues[i].hashCode();
        }
        for (i = 0; i < this.intervalDayTimeValues.length; ++i) {
            hash ^= this.intervalDayTimeValues[i].hashCode();
        }
        Murmur3.IncrementalHash32 bytesHash = null;
        for (int i2 = 0; i2 < this.byteValues.length; ++i2) {
            if (this.byteLengths[i2] == -1) continue;
            if (bytesHash == null) {
                bytesHash = VectorHashKeyWrapperBase.HashContext.getBytesHash(this.hashCtx);
                bytesHash.start(hash);
            }
            bytesHash.add(this.byteValues[i2], this.byteStarts[i2], this.byteLengths[i2]);
        }
        if (bytesHash != null) {
            hash = bytesHash.end();
        }
        this.hashcode = hash;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof VectorHashKeyWrapperGeneral) {
            VectorHashKeyWrapperGeneral keyThat = (VectorHashKeyWrapperGeneral)that;
            return this.hashcode == keyThat.hashcode && Arrays.equals(this.longValues, keyThat.longValues) && Arrays.equals(this.doubleValues, keyThat.doubleValues) && Arrays.equals(this.decimalValues, keyThat.decimalValues) && Arrays.equals(this.timestampValues, keyThat.timestampValues) && Arrays.equals(this.intervalDayTimeValues, keyThat.intervalDayTimeValues) && Arrays.equals(this.isNull, keyThat.isNull) && this.byteValues.length == keyThat.byteValues.length && (0 == this.byteValues.length || this.bytesEquals(keyThat));
        }
        return false;
    }

    private boolean bytesEquals(VectorHashKeyWrapperGeneral keyThat) {
        for (int i = 0; i < this.byteValues.length; ++i) {
            if (this.byteLengths[i] == -1 || StringExpr.equal((byte[])this.byteValues[i], (int)this.byteStarts[i], (int)this.byteLengths[i], (byte[])keyThat.byteValues[i], (int)keyThat.byteStarts[i], (int)keyThat.byteLengths[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object clone() {
        int i;
        VectorHashKeyWrapperGeneral clone = new VectorHashKeyWrapperGeneral();
        clone.hashCtx = this.hashCtx;
        clone.keyCount = this.keyCount;
        clone.longValues = this.longValues.length > 0 ? (long[])this.longValues.clone() : EMPTY_LONG_ARRAY;
        clone.doubleValues = this.doubleValues.length > 0 ? (double[])this.doubleValues.clone() : EMPTY_DOUBLE_ARRAY;
        clone.isNull = (boolean[])this.isNull.clone();
        if (this.decimalValues.length > 0) {
            clone.decimalValues = new HiveDecimalWritable[this.decimalValues.length];
            for (i = 0; i < this.decimalValues.length; ++i) {
                clone.decimalValues[i] = new HiveDecimalWritable(this.decimalValues[i]);
            }
        } else {
            clone.decimalValues = EMPTY_DECIMAL_ARRAY;
        }
        if (this.byteLengths.length > 0) {
            clone.byteValues = new byte[this.byteValues.length][];
            clone.byteStarts = new int[this.byteValues.length];
            clone.byteLengths = (int[])this.byteLengths.clone();
            for (i = 0; i < this.byteValues.length; ++i) {
                if (this.byteLengths[i] == -1) continue;
                clone.byteValues[i] = Arrays.copyOfRange(this.byteValues[i], this.byteStarts[i], this.byteStarts[i] + this.byteLengths[i]);
            }
        } else {
            clone.byteValues = EMPTY_BYTES_ARRAY;
            clone.byteStarts = EMPTY_INT_ARRAY;
            clone.byteLengths = EMPTY_INT_ARRAY;
        }
        if (this.timestampValues.length > 0) {
            clone.timestampValues = new Timestamp[this.timestampValues.length];
            for (i = 0; i < this.timestampValues.length; ++i) {
                clone.timestampValues[i] = (Timestamp)this.timestampValues[i].clone();
            }
        } else {
            clone.timestampValues = EMPTY_TIMESTAMP_ARRAY;
        }
        if (this.intervalDayTimeValues.length > 0) {
            clone.intervalDayTimeValues = new HiveIntervalDayTime[this.intervalDayTimeValues.length];
            for (i = 0; i < this.intervalDayTimeValues.length; ++i) {
                clone.intervalDayTimeValues[i] = (HiveIntervalDayTime)this.intervalDayTimeValues[i].clone();
            }
        } else {
            clone.intervalDayTimeValues = EMPTY_INTERVAL_DAY_TIME_ARRAY;
        }
        clone.hashcode = this.hashcode;
        assert (clone.equals(this));
        return clone;
    }

    private long[] copyInPlaceOrAllocate(long[] from, long[] to) {
        if (from.length > 0) {
            if (to != null && to.length == from.length) {
                System.arraycopy(from, 0, to, 0, from.length);
                return to;
            }
            return (long[])from.clone();
        }
        return EMPTY_LONG_ARRAY;
    }

    private double[] copyInPlaceOrAllocate(double[] from, double[] to) {
        if (from.length > 0) {
            if (to != null && to.length == from.length) {
                System.arraycopy(from, 0, to, 0, from.length);
                return to;
            }
            return (double[])from.clone();
        }
        return EMPTY_DOUBLE_ARRAY;
    }

    private boolean[] copyInPlaceOrAllocate(boolean[] from, boolean[] to) {
        if (to != null && to.length == from.length) {
            System.arraycopy(from, 0, to, 0, from.length);
            return to;
        }
        return (boolean[])from.clone();
    }

    private HiveDecimalWritable[] copyInPlaceOrAllocate(HiveDecimalWritable[] from, HiveDecimalWritable[] to) {
        if (from.length > 0) {
            if (to == null || to.length != from.length) {
                to = new HiveDecimalWritable[from.length];
            }
            for (int i = 0; i < from.length; ++i) {
                to[i] = new HiveDecimalWritable(from[i]);
            }
            return to;
        }
        return EMPTY_DECIMAL_ARRAY;
    }

    private Timestamp[] copyInPlaceOrAllocate(Timestamp[] from, Timestamp[] to) {
        if (from.length > 0) {
            if (to == null || to.length != from.length) {
                to = new Timestamp[from.length];
            }
            for (int i = 0; i < from.length; ++i) {
                to[i] = (Timestamp)from[i].clone();
            }
            return to;
        }
        return EMPTY_TIMESTAMP_ARRAY;
    }

    @Override
    public void copyKey(KeyWrapper oldWrapper) {
        VectorHashKeyWrapperGeneral clone = (VectorHashKeyWrapperGeneral)oldWrapper;
        clone.hashCtx = this.hashCtx;
        clone.keyCount = this.keyCount;
        clone.longValues = this.copyInPlaceOrAllocate(this.longValues, clone.longValues);
        clone.doubleValues = this.copyInPlaceOrAllocate(this.doubleValues, clone.doubleValues);
        clone.isNull = this.copyInPlaceOrAllocate(this.isNull, clone.isNull);
        clone.decimalValues = this.copyInPlaceOrAllocate(this.decimalValues, clone.decimalValues);
        if (this.byteLengths.length > 0) {
            if (clone.byteLengths == null || clone.byteValues.length != this.byteValues.length) {
                clone.byteValues = new byte[this.byteValues.length][];
                clone.byteStarts = new int[this.byteValues.length];
                clone.byteLengths = (int[])this.byteLengths.clone();
                for (int i = 0; i < this.byteValues.length; ++i) {
                    if (this.byteLengths[i] == -1) continue;
                    clone.byteValues[i] = Arrays.copyOfRange(this.byteValues[i], this.byteStarts[i], this.byteStarts[i] + this.byteLengths[i]);
                }
            } else {
                System.arraycopy(this.byteLengths, 0, clone.byteLengths, 0, this.byteValues.length);
                Arrays.fill(clone.byteStarts, 0);
                for (int i = 0; i < this.byteValues.length; ++i) {
                    if (this.byteLengths[i] == -1) continue;
                    if (clone.byteValues[i] != null && clone.byteValues[i].length >= this.byteValues[i].length) {
                        System.arraycopy(this.byteValues[i], this.byteStarts[i], clone.byteValues[i], 0, this.byteLengths[i]);
                        continue;
                    }
                    clone.byteValues[i] = Arrays.copyOfRange(this.byteValues[i], this.byteStarts[i], this.byteStarts[i] + this.byteLengths[i]);
                }
            }
        } else {
            clone.byteValues = EMPTY_BYTES_ARRAY;
            clone.byteStarts = EMPTY_INT_ARRAY;
            clone.byteLengths = EMPTY_INT_ARRAY;
        }
        clone.timestampValues = this.copyInPlaceOrAllocate(this.timestampValues, clone.timestampValues);
        clone.intervalDayTimeValues = this.copyInPlaceOrAllocate(this.intervalDayTimeValues, clone.intervalDayTimeValues);
        clone.hashcode = this.hashcode;
        assert (clone.equals(this));
    }

    private HiveIntervalDayTime[] copyInPlaceOrAllocate(HiveIntervalDayTime[] from, HiveIntervalDayTime[] to) {
        if (from.length > 0) {
            if (to == null || to.length != from.length) {
                to = new HiveIntervalDayTime[from.length];
            }
            for (int i = 0; i < from.length; ++i) {
                to[i] = (HiveIntervalDayTime)from[i].clone();
            }
            return to;
        }
        return EMPTY_INTERVAL_DAY_TIME_ARRAY;
    }

    @Override
    public void assignLong(int keyIndex, int index, long v) {
        this.isNull[keyIndex] = false;
        this.longValues[index] = v;
    }

    @Override
    @Deprecated
    public void assignLong(int index, long v) {
        this.longValues[index] = v;
    }

    @Override
    public void assignNullLong(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.longValues[index] = 0L;
    }

    @Override
    public void assignDouble(int index, double d) {
        this.doubleValues[index] = d;
    }

    @Override
    public void assignNullDouble(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.doubleValues[index] = 0.0;
    }

    @Override
    public void assignString(int index, byte[] bytes, int start, int length) {
        Preconditions.checkState((bytes != null ? 1 : 0) != 0);
        this.byteValues[index] = bytes;
        this.byteStarts[index] = start;
        this.byteLengths[index] = length;
    }

    @Override
    public void assignNullString(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.byteValues[index] = null;
        this.byteStarts[index] = 0;
        this.byteLengths[index] = -1;
    }

    @Override
    public void assignDecimal(int index, HiveDecimalWritable value) {
        this.decimalValues[index].set(value);
    }

    @Override
    public void assignNullDecimal(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.decimalValues[index].set(HiveDecimal.ZERO);
    }

    @Override
    public void assignTimestamp(int index, Timestamp value) {
        this.timestampValues[index].setTime(value.getTime());
        this.timestampValues[index].setNanos(value.getNanos());
    }

    @Override
    public void assignTimestamp(int index, TimestampColumnVector colVector, int elementNum) {
        colVector.timestampUpdate(this.timestampValues[index], elementNum);
    }

    @Override
    public void assignNullTimestamp(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.timestampValues[index].setTime(ZERO_TIMESTAMP.getTime());
        this.timestampValues[index].setNanos(ZERO_TIMESTAMP.getNanos());
    }

    @Override
    public void assignIntervalDayTime(int index, HiveIntervalDayTime value) {
        this.intervalDayTimeValues[index].set(value);
    }

    @Override
    public void assignIntervalDayTime(int index, IntervalDayTimeColumnVector colVector, int elementNum) {
        this.intervalDayTimeValues[index].set(colVector.asScratchIntervalDayTime(elementNum));
    }

    @Override
    public void assignNullIntervalDayTime(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.intervalDayTimeValues[index].set(ZERO_INTERVALDAYTIME);
    }

    @Override
    public String stringifyKeys(VectorColumnSetInfo columnSetInfo) {
        int keyIndex;
        int i;
        boolean isFirstValue;
        StringBuilder sb = new StringBuilder();
        boolean isFirstKey = true;
        if (this.longValues.length > 0) {
            isFirstKey = false;
            sb.append("longs ");
            isFirstValue = true;
            block3: for (i = 0; i < columnSetInfo.longIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.longIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.longValues[i]);
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)columnSetInfo.typeInfos[keyIndex];
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case DATE: {
                        Date dt = new Date(0L);
                        dt.setTime(DateWritableV2.daysToMillis((int)((int)this.longValues[i])));
                        sb.append(" date ");
                        sb.append(dt.toString());
                        continue block3;
                    }
                }
            }
        }
        if (this.doubleValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append("doubles ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.doubleIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.doubleIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.doubleValues[i]);
            }
        }
        if (this.byteValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append("byte lengths ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.stringIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.stringIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.byteLengths[i]);
            }
        }
        if (this.decimalValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = true;
            } else {
                sb.append(", ");
            }
            sb.append("decimals ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.decimalIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.decimalIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.decimalValues[i]);
            }
        }
        if (this.timestampValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append("timestamps ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.timestampIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.timestampIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.timestampValues[i]);
            }
        }
        if (this.intervalDayTimeValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append("interval day times ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.intervalDayTimeIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.intervalDayTimeIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.intervalDayTimeValues[i]);
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        if (this.longValues.length > 0) {
            isFirst = false;
            sb.append("longs ");
            sb.append(Arrays.toString(this.longValues));
        }
        if (this.doubleValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("doubles ");
            sb.append(Arrays.toString(this.doubleValues));
        }
        if (this.byteValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("byte lengths ");
            sb.append(Arrays.toString(this.byteLengths));
        }
        if (this.decimalValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("decimals ");
            sb.append(Arrays.toString(this.decimalValues));
        }
        if (this.timestampValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("timestamps ");
            sb.append(Arrays.toString(this.timestampValues));
        }
        if (this.intervalDayTimeValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("interval day times ");
            sb.append(Arrays.toString(this.intervalDayTimeValues));
        }
        if (isFirst) {
            isFirst = false;
        } else {
            sb.append(", ");
        }
        sb.append("nulls ");
        sb.append(Arrays.toString(this.isNull));
        return sb.toString();
    }

    @Override
    public long getLongValue(int i) {
        return this.longValues[i];
    }

    @Override
    public double getDoubleValue(int i) {
        return this.doubleValues[i];
    }

    @Override
    public byte[] getBytes(int i) {
        return this.byteValues[i];
    }

    @Override
    public int getByteStart(int i) {
        return this.byteStarts[i];
    }

    @Override
    public int getByteLength(int i) {
        return this.byteLengths[i];
    }

    @Override
    public HiveDecimalWritable getDecimal(int i) {
        return this.decimalValues[i];
    }

    @Override
    public Timestamp getTimestamp(int i) {
        return this.timestampValues[i];
    }

    @Override
    public HiveIntervalDayTime getIntervalDayTime(int i) {
        return this.intervalDayTimeValues[i];
    }

    @Override
    public int getVariableSize() {
        int variableSize = 0;
        for (int i = 0; i < this.byteLengths.length; ++i) {
            JavaDataModel model = JavaDataModel.get();
            variableSize = (int)((long)variableSize + model.lengthForByteArrayOfSize((long)this.byteLengths[i]));
        }
        return variableSize;
    }

    @Override
    public void clearIsNull() {
        Arrays.fill(this.isNull, false);
    }

    @Override
    public void setNull() {
        Arrays.fill(this.isNull, true);
    }

    @Override
    public boolean isNull(int keyIndex) {
        return this.isNull[keyIndex];
    }
}

