/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Reporter;

public interface AcidOutputFormat<K extends WritableComparable, V>
extends HiveOutputFormat<K, V> {
    public RecordUpdater getRecordUpdater(Path var1, Options var2) throws IOException;

    public FileSinkOperator.RecordWriter getRawRecordWriter(Path var1, Options var2) throws IOException;

    public static class Options
    implements Cloneable {
        private final Configuration configuration;
        private FileSystem fs;
        private ObjectInspector inspector;
        private boolean writingBase = false;
        private boolean writingDeleteDelta = false;
        private boolean isCompressed = false;
        private Properties properties;
        private Reporter reporter;
        private long minimumWriteId;
        private long maximumWriteId;
        private Integer attemptId;
        private int bucketId;
        private PrintStream dummyStream = null;
        private boolean oldStyle = false;
        private int recIdCol = -1;
        private int statementId = 0;
        private Path finalDestination;
        private long visibilityTxnId = 0L;
        private boolean temporary = false;
        private final boolean writeVersionFile;
        private int maxStmtId = -1;

        public Options(Configuration conf) {
            this.configuration = conf;
            this.writeVersionFile = conf != null ? HiveConf.getBoolVar((Configuration)this.configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE) : true;
        }

        public Options clone() {
            try {
                return (Options)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("clone() not properly implemented: " + ex.getMessage(), ex);
            }
        }

        public Options inspector(ObjectInspector inspector) {
            this.inspector = inspector;
            return this;
        }

        public Options writingBase(boolean val) {
            this.writingBase = val;
            return this;
        }

        public Options writingDeleteDelta(boolean val) {
            this.writingDeleteDelta = val;
            return this;
        }

        public Options filesystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        public Options isCompressed(boolean isCompressed) {
            this.isCompressed = isCompressed;
            return this;
        }

        public Options tableProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Options reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public Options minimumWriteId(long min) {
            this.minimumWriteId = min;
            return this;
        }

        public Options maximumWriteId(long max) {
            this.maximumWriteId = max;
            return this;
        }

        public Options bucket(int bucket) {
            this.bucketId = bucket;
            return this;
        }

        Options setOldStyle(boolean value) {
            this.oldStyle = value;
            return this;
        }

        public Options recordIdColumn(int recIdCol) {
            this.recIdCol = recIdCol;
            return this;
        }

        public Options useDummy(PrintStream stream) {
            this.dummyStream = stream;
            return this;
        }

        public Options attemptId(Integer attemptId) {
            this.attemptId = attemptId;
            return this;
        }

        public Options statementId(int id) {
            if (id >= 10000) {
                throw new RuntimeException("Too many statements for writeId: " + this.maximumWriteId);
            }
            if (id < -1) {
                throw new IllegalArgumentException("Illegal statementId value: " + id);
            }
            this.statementId = id;
            return this;
        }

        public Options finalDestination(Path p) {
            this.finalDestination = p;
            return this;
        }

        public Options visibilityTxnId(long visibilityTxnId) {
            this.visibilityTxnId = visibilityTxnId;
            return this;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public FileSystem getFilesystem() {
            return this.fs;
        }

        public ObjectInspector getInspector() {
            return this.inspector;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public Properties getTableProperties() {
            return this.properties;
        }

        public Reporter getReporter() {
            return this.reporter;
        }

        public long getMinimumWriteId() {
            return this.minimumWriteId;
        }

        public long getMaximumWriteId() {
            return this.maximumWriteId;
        }

        public boolean isWritingBase() {
            return this.writingBase;
        }

        public boolean isWritingDeleteDelta() {
            return this.writingDeleteDelta;
        }

        public int getBucketId() {
            return this.bucketId;
        }

        public Integer getAttemptId() {
            return this.attemptId;
        }

        public int getRecordIdColumn() {
            return this.recIdCol;
        }

        public PrintStream getDummyStream() {
            return this.dummyStream;
        }

        boolean getOldStyle() {
            return this.oldStyle;
        }

        public int getStatementId() {
            return this.statementId;
        }

        public Path getFinalDestination() {
            return this.finalDestination;
        }

        public long getVisibilityTxnId() {
            return this.visibilityTxnId;
        }

        public boolean isWriteVersionFile() {
            return this.writeVersionFile;
        }

        public Options temporary(boolean temporary) {
            this.temporary = temporary;
            return this;
        }

        public boolean isTemporary() {
            return this.temporary;
        }

        public Options maxStmtId(int maxStmtId) {
            this.maxStmtId = maxStmtId;
            return this;
        }

        public int getMaxStmtId() {
            return this.maxStmtId;
        }
    }
}

