/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.StorageFormatFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SchemaInference;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.util.ReflectionUtils;

public class SchemaInferenceUtils {
    private static Class<AbstractSerDe> getSerde(Configuration conf, String fileFormat) throws HiveException {
        StorageFormatFactory storageFormatFactory = new StorageFormatFactory();
        StorageFormatDescriptor descriptor = storageFormatFactory.get(fileFormat);
        if (descriptor == null) {
            throw new HiveException(ErrorMsg.CTLF_MISSING_STORAGE_FORMAT_DESCRIPTOR.getErrorCodedMsg(new String[]{fileFormat}));
        }
        String serde = descriptor.getSerde();
        try {
            return conf.getClassByName(serde);
        }
        catch (ClassNotFoundException e) {
            throw new HiveException(ErrorMsg.CTLF_CLASS_NOT_FOUND.getErrorCodedMsg(new String[]{serde, fileFormat}), (Throwable)e);
        }
    }

    public static boolean doesSupportSchemaInference(Configuration conf, String fileFormat) throws HiveException {
        return SchemaInference.class.isAssignableFrom(SchemaInferenceUtils.getSerde(conf, fileFormat));
    }

    public static List<FieldSchema> readSchemaFromFile(Configuration conf, String fileFormat, String filePath) throws HiveException {
        Class<AbstractSerDe> asClass = SchemaInferenceUtils.getSerde(conf, fileFormat);
        SchemaInference sd = (SchemaInference)ReflectionUtils.newInstance(asClass, (Configuration)conf);
        try {
            return sd.readSchema(conf, filePath);
        }
        catch (SerDeException e) {
            throw new HiveException(ErrorMsg.CTLF_FAILED_INFERENCE.getErrorCodedMsg(), (Throwable)e);
        }
    }
}

