/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class HiveSchemaConverter {
    public static MessageType convert(List<String> columnNames, List<TypeInfo> columnTypes) {
        return HiveSchemaConverter.convert(columnNames, columnTypes, null);
    }

    public static MessageType convert(List<String> columnNames, List<TypeInfo> columnTypes, Configuration conf) {
        MessageType schema = new MessageType("hive_schema", HiveSchemaConverter.convertTypes(columnNames, columnTypes, conf));
        return schema;
    }

    private static Type[] convertTypes(List<String> columnNames, List<TypeInfo> columnTypes, Configuration conf) {
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalStateException("Mismatched Hive columns and types. Hive columns names found : " + String.valueOf(columnNames) + " . And Hive types found : " + String.valueOf(columnTypes));
        }
        Type[] types = new Type[columnNames.size()];
        for (int i = 0; i < columnNames.size(); ++i) {
            types[i] = HiveSchemaConverter.convertType(columnNames.get(i), columnTypes.get(i), conf);
        }
        return types;
    }

    private static Type convertType(String name, TypeInfo typeInfo, Configuration conf) {
        return HiveSchemaConverter.convertType(name, typeInfo, conf, Type.Repetition.OPTIONAL);
    }

    private static Type convertType(String name, TypeInfo typeInfo, Configuration conf, Type.Repetition repetition) {
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            if (typeInfo.equals((Object)TypeInfoFactory.stringTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.intTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.shortTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.byteTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true))).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.longTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.floatTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
                String timeUnitVal;
                boolean useInt64;
                if (conf != null) {
                    useInt64 = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PARQUET_WRITE_INT64_TIMESTAMP);
                    timeUnitVal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_TIME_UNIT);
                } else {
                    useInt64 = HiveConf.ConfVars.HIVE_PARQUET_WRITE_INT64_TIMESTAMP.defaultBoolVal;
                    timeUnitVal = HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_TIME_UNIT.defaultStrVal;
                }
                if (useInt64) {
                    LogicalTypeAnnotation.TimeUnit timeUnit = LogicalTypeAnnotation.TimeUnit.valueOf((String)timeUnitVal.toUpperCase());
                    return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)timeUnit))).named(name);
                }
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.voidTypeInfo)) {
                throw new UnsupportedOperationException("Void type not implemented");
            }
            if (typeInfo.getTypeName().toLowerCase().startsWith("char")) {
                return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
            }
            if (typeInfo.getTypeName().toLowerCase().startsWith("varchar")) {
                return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
            }
            if (typeInfo instanceof DecimalTypeInfo) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                int prec = decimalTypeInfo.precision();
                int scale = decimalTypeInfo.scale();
                int bytes = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1];
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(bytes)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)prec))).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.dateTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.unknownTypeInfo)) {
                throw new UnsupportedOperationException("Unknown type not implemented");
            }
            throw new IllegalArgumentException("Unknown type: " + String.valueOf(typeInfo));
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            return HiveSchemaConverter.convertArrayType(name, (ListTypeInfo)typeInfo, conf);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return HiveSchemaConverter.convertStructType(name, (StructTypeInfo)typeInfo, conf);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            return HiveSchemaConverter.convertMapType(name, (MapTypeInfo)typeInfo, conf);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.UNION)) {
            throw new UnsupportedOperationException("Union type not implemented");
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(typeInfo));
    }

    private static GroupType convertArrayType(String name, ListTypeInfo typeInfo, Configuration conf) {
        TypeInfo subType = typeInfo.getListElementTypeInfo();
        GroupType groupType = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)((Types.GroupBuilder)Types.repeatedGroup().addField(HiveSchemaConverter.convertType("array_element", subType, conf))).named(ParquetHiveSerDe.ARRAY.toString()))).named(name);
        return groupType;
    }

    private static GroupType convertStructType(String name, StructTypeInfo typeInfo, Configuration conf) {
        List columnNames = typeInfo.getAllStructFieldNames();
        List columnTypes = typeInfo.getAllStructFieldTypeInfos();
        GroupType groupType = (GroupType)((Types.GroupBuilder)Types.optionalGroup().addFields(HiveSchemaConverter.convertTypes(columnNames, columnTypes, conf))).named(name);
        return groupType;
    }

    private static GroupType convertMapType(String name, MapTypeInfo typeInfo, Configuration conf) {
        Type keyType = HiveSchemaConverter.convertType(ParquetHiveSerDe.MAP_KEY.toString(), typeInfo.getMapKeyTypeInfo(), conf, Type.Repetition.REQUIRED);
        Type valueType = HiveSchemaConverter.convertType(ParquetHiveSerDe.MAP_VALUE.toString(), typeInfo.getMapValueTypeInfo(), conf);
        return ConversionPatterns.mapType((Type.Repetition)Type.Repetition.OPTIONAL, (String)name, (Type)keyType, (Type)valueType);
    }
}

