/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.IOException;
import java.time.ZoneId;
import org.apache.hadoop.hive.common.type.CalendarUtils;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.io.parquet.vector.BaseVectorizedColumnReader;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.Type;

public class VectorizedPrimitiveColumnReader
extends BaseVectorizedColumnReader {
    public VectorizedPrimitiveColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean skipTimestampConversion, ZoneId writerTimezone, boolean skipProlepticConversion, boolean legacyConversionEnabled, Type type, TypeInfo hiveType) throws IOException {
        super(descriptor, pageReader, skipTimestampConversion, writerTimezone, skipProlepticConversion, legacyConversionEnabled, type, hiveType);
    }

    @Override
    public void readBatch(int total, ColumnVector column, TypeInfo columnType) throws IOException {
        int rowId = 0;
        while (total > 0) {
            int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            if (leftInPage == 0) {
                this.readPage();
                leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            }
            int num = Math.min(total, leftInPage);
            if (this.isCurrentPageDictionaryEncoded) {
                LongColumnVector dictionaryIds = new LongColumnVector();
                this.readDictionaryIDs(num, dictionaryIds, rowId);
                this.decodeDictionaryIds(rowId, num, column, columnType, dictionaryIds);
            } else {
                this.readBatchHelper(num, column, columnType, rowId);
            }
            rowId += num;
            total -= num;
        }
    }

    private void readBatchHelper(int num, ColumnVector column, TypeInfo columnType, int rowId) throws IOException {
        PrimitiveTypeInfo primitiveColumnType = (PrimitiveTypeInfo)columnType;
        switch (primitiveColumnType.getPrimitiveCategory()) {
            case INT: {
                this.readIntegers(num, (LongColumnVector)column, rowId);
                break;
            }
            case BYTE: {
                this.readTinyInts(num, (LongColumnVector)column, rowId);
                break;
            }
            case SHORT: {
                this.readSmallInts(num, (LongColumnVector)column, rowId);
                break;
            }
            case DATE: {
                this.readDate(num, (DateColumnVector)column, rowId);
                break;
            }
            case INTERVAL_YEAR_MONTH: 
            case LONG: {
                this.readLongs(num, (LongColumnVector)column, rowId);
                break;
            }
            case BOOLEAN: {
                this.readBooleans(num, (LongColumnVector)column, rowId);
                break;
            }
            case DOUBLE: {
                this.readDoubles(num, (DoubleColumnVector)column, rowId);
                break;
            }
            case BINARY: {
                this.readBinaries(num, (BytesColumnVector)column, rowId);
                break;
            }
            case STRING: {
                this.readString(num, (BytesColumnVector)column, rowId);
                break;
            }
            case VARCHAR: {
                this.readVarchar(num, (BytesColumnVector)column, rowId);
                break;
            }
            case CHAR: {
                this.readChar(num, (BytesColumnVector)column, rowId);
                break;
            }
            case FLOAT: {
                this.readFloats(num, (DoubleColumnVector)column, rowId);
                break;
            }
            case DECIMAL: {
                this.readDecimal(num, (DecimalColumnVector)column, rowId);
                break;
            }
            case TIMESTAMP: {
                this.readTimestamp(num, (TimestampColumnVector)column, rowId);
                break;
            }
            default: {
                throw new IOException("Unsupported type: " + String.valueOf(this.type));
            }
        }
    }

    private static void setNullValue(ColumnVector c, int rowId) {
        c.isNull[rowId] = true;
        c.isRepeating = false;
        c.noNulls = false;
    }

    private void readDictionaryIDs(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readValueDictionaryId();
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readIntegers(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readInteger();
                if (this.dataColumn.isValid()) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0L;
                    VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readSmallInts(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readSmallInt();
                if (this.dataColumn.isValid()) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0L;
                    VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readTinyInts(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readTinyInt();
                if (this.dataColumn.isValid()) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0L;
                    VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readDoubles(int total, DoubleColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readDouble();
                if (this.dataColumn.isValid()) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0.0;
                    VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readBooleans(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readBoolean() ? 1L : 0L;
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readLongs(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readLong();
                if (this.dataColumn.isValid()) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0L;
                    VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readFloats(int total, DoubleColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readFloat();
                if (this.dataColumn.isValid()) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0.0;
                    VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readDecimal(int total, DecimalColumnVector c, int rowId) throws IOException {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType = null;
        if (this.type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            decimalLogicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.type.getLogicalTypeAnnotation();
        }
        byte[] decimalData = null;
        this.fillDecimalPrecisionScale(decimalLogicalType, c);
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                decimalData = this.dataColumn.readDecimal();
                if (this.dataColumn.isValid()) {
                    c.vector[rowId].set(decimalData, (int)c.scale);
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readString(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readString());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readChar(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readChar());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readVarchar(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readVarchar());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readBinaries(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readBytes());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readDate(int total, DateColumnVector c, int rowId) throws IOException {
        c.setUsingProlepticCalendar(true);
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                long l = c.vector[rowId] = this.skipProlepticConversion ? this.dataColumn.readLong() : (long)CalendarUtils.convertDateToProleptic((int)((int)this.dataColumn.readLong()));
                if (this.dataColumn.isValid()) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0L;
                    VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void readTimestamp(int total, TimestampColumnVector c, int rowId) throws IOException {
        c.setUsingProlepticCalendar(true);
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                switch (this.descriptor.getType()) {
                    case INT96: {
                        c.set(rowId, this.dataColumn.readTimestamp().toSqlTimestamp());
                        break;
                    }
                    case INT64: {
                        c.set(rowId, this.dataColumn.readTimestamp().toSqlTimestamp());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported parquet logical type: " + this.type.getLogicalTypeAnnotation().toString() + " for timestamp");
                    }
                }
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.time[0] == c.time[rowId] && c.nanos[0] == c.nanos[rowId];
            } else {
                VectorizedPrimitiveColumnReader.setNullValue((ColumnVector)c, rowId);
            }
            ++rowId;
        }
    }

    private void decodeDictionaryIds(int rowId, int num, ColumnVector column, TypeInfo columnType, LongColumnVector dictionaryIds) {
        System.arraycopy(dictionaryIds.isNull, rowId, column.isNull, rowId, num);
        if (column.noNulls) {
            column.noNulls = dictionaryIds.noNulls;
        }
        column.isRepeating = column.isRepeating && dictionaryIds.isRepeating;
        PrimitiveTypeInfo primitiveColumnType = (PrimitiveTypeInfo)columnType;
        switch (primitiveColumnType.getPrimitiveCategory()) {
            case INT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((LongColumnVector)column).vector[i] = this.dictionary.readInteger((int)dictionaryIds.vector[i]);
                    if (this.dictionary.isValid()) continue;
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    ((LongColumnVector)column).vector[i] = 0L;
                }
                break;
            }
            case BYTE: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((LongColumnVector)column).vector[i] = this.dictionary.readTinyInt((int)dictionaryIds.vector[i]);
                    if (this.dictionary.isValid()) continue;
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    ((LongColumnVector)column).vector[i] = 0L;
                }
                break;
            }
            case SHORT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((LongColumnVector)column).vector[i] = this.dictionary.readSmallInt((int)dictionaryIds.vector[i]);
                    if (this.dictionary.isValid()) continue;
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    ((LongColumnVector)column).vector[i] = 0L;
                }
                break;
            }
            case DATE: {
                DateColumnVector dc = (DateColumnVector)column;
                dc.setUsingProlepticCalendar(true);
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    long l = dc.vector[i] = this.skipProlepticConversion ? this.dictionary.readLong((int)dictionaryIds.vector[i]) : (long)CalendarUtils.convertDateToProleptic((int)((int)this.dictionary.readLong((int)dictionaryIds.vector[i])));
                    if (this.dictionary.isValid()) continue;
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    dc.vector[i] = 0L;
                }
                break;
            }
            case INTERVAL_YEAR_MONTH: 
            case LONG: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((LongColumnVector)column).vector[i] = this.dictionary.readLong((int)dictionaryIds.vector[i]);
                    if (this.dictionary.isValid()) continue;
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    ((LongColumnVector)column).vector[i] = 0L;
                }
                break;
            }
            case BOOLEAN: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((LongColumnVector)column).vector[i] = this.dictionary.readBoolean((int)dictionaryIds.vector[i]) ? 1L : 0L;
                }
                break;
            }
            case DOUBLE: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((DoubleColumnVector)column).vector[i] = this.dictionary.readDouble((int)dictionaryIds.vector[i]);
                    if (this.dictionary.isValid()) continue;
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    ((DoubleColumnVector)column).vector[i] = 0.0;
                }
                break;
            }
            case BINARY: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((BytesColumnVector)column).setVal(i, this.dictionary.readBytes((int)dictionaryIds.vector[i]));
                }
                break;
            }
            case STRING: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((BytesColumnVector)column).setVal(i, this.dictionary.readString((int)dictionaryIds.vector[i]));
                }
                break;
            }
            case VARCHAR: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((BytesColumnVector)column).setVal(i, this.dictionary.readVarchar((int)dictionaryIds.vector[i]));
                }
                break;
            }
            case CHAR: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((BytesColumnVector)column).setVal(i, this.dictionary.readChar((int)dictionaryIds.vector[i]));
                }
                break;
            }
            case FLOAT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    ((DoubleColumnVector)column).vector[i] = this.dictionary.readFloat((int)dictionaryIds.vector[i]);
                    if (this.dictionary.isValid()) continue;
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    ((DoubleColumnVector)column).vector[i] = 0.0;
                }
                break;
            }
            case DECIMAL: {
                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType = null;
                if (this.type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    decimalLogicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.type.getLogicalTypeAnnotation();
                }
                DecimalColumnVector decimalColumnVector = (DecimalColumnVector)column;
                byte[] decimalData = null;
                this.fillDecimalPrecisionScale(decimalLogicalType, decimalColumnVector);
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    decimalData = this.dictionary.readDecimal((int)dictionaryIds.vector[i]);
                    if (this.dictionary.isValid()) {
                        decimalColumnVector.vector[i].set(decimalData, (int)decimalColumnVector.scale);
                        continue;
                    }
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                }
                break;
            }
            case TIMESTAMP: {
                TimestampColumnVector tsc = (TimestampColumnVector)column;
                tsc.setUsingProlepticCalendar(true);
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNull[i]) continue;
                    tsc.set(i, this.dictionary.readTimestamp((int)dictionaryIds.vector[i]).toSqlTimestamp());
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(this.type));
            }
        }
    }

    private void fillDecimalPrecisionScale(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType, DecimalColumnVector decimalColumnVector) {
        if (decimalLogicalType != null) {
            decimalColumnVector.precision = (short)decimalLogicalType.getPrecision();
            decimalColumnVector.scale = (short)decimalLogicalType.getScale();
        } else if (TypeInfoUtils.getBaseName((String)this.hiveType.getTypeName()).equalsIgnoreCase("decimal")) {
            decimalColumnVector.precision = (short)((DecimalTypeInfo)this.hiveType).getPrecision();
            decimalColumnVector.scale = (short)((DecimalTypeInfo)this.hiveType).getScale();
        } else {
            throw new UnsupportedOperationException("The underlying Parquet type cannot be converted to Hive Decimal type: " + String.valueOf(this.type));
        }
    }
}

