/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.ArrayList;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAggregatePartitionIncrementalRewritingRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAggregatePartitionIncrementalRewritingRule.class);
    public static final HiveAggregatePartitionIncrementalRewritingRule INSTANCE = new HiveAggregatePartitionIncrementalRewritingRule();

    private HiveAggregatePartitionIncrementalRewritingRule() {
        super(HiveAggregatePartitionIncrementalRewritingRule.operand(Aggregate.class, (RelOptRuleOperand)HiveAggregatePartitionIncrementalRewritingRule.operand(Union.class, (RelOptRuleOperandChildren)HiveAggregatePartitionIncrementalRewritingRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), HiveRelFactories.HIVE_BUILDER, "HiveAggregatePartitionIncrementalRewritingRule");
    }

    public void onMatch(RelOptRuleCall call) {
        Object relDataTypeField;
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        Aggregate aggregate = (Aggregate)call.rel(0);
        Union union = (Union)call.rel(1);
        RelNode queryBranch = union.getInput(0);
        RelNode mvBranch = union.getInput(1);
        RelMetadataQuery relMetadataQuery = RelMetadataQuery.instance();
        int partitionColumnCount = -1;
        ArrayList<Integer> partitionColumnIndexes = new ArrayList<Integer>();
        for (int i = 0; i < mvBranch.getRowType().getFieldList().size(); ++i) {
            Set<RexTableInputRef> tableInputRefs;
            relDataTypeField = (RelDataTypeField)mvBranch.getRowType().getFieldList().get(i);
            RexInputRef inputRef = rexBuilder.makeInputRef(relDataTypeField.getType(), i);
            Set expressionLineage = relMetadataQuery.getExpressionLineage(mvBranch, (RexNode)inputRef);
            if (expressionLineage == null || expressionLineage.size() != 1 || (tableInputRefs = HiveCalciteUtil.findRexTableInputRefs((RexNode)expressionLineage.iterator().next())).size() != 1) continue;
            RexTableInputRef tableInputRef = tableInputRefs.iterator().next();
            RelOptHiveTable relOptHiveTable = (RelOptHiveTable)tableInputRef.getTableRef().getTable();
            if (!relOptHiveTable.getHiveTableMD().isMaterializedView()) {
                LOG.warn("{} is not a materialized view, bail out.", relOptHiveTable.getQualifiedName());
                return;
            }
            partitionColumnCount = relOptHiveTable.getPartColInfoMap().size();
            if (!relOptHiveTable.getPartColInfoMap().containsKey(tableInputRef.getIndex())) continue;
            partitionColumnIndexes.add(i);
        }
        if (partitionColumnCount <= 0 || partitionColumnIndexes.size() != partitionColumnCount) {
            LOG.debug("Could not find all partition column lineages, bail out.");
            return;
        }
        ArrayList<RexNode> joinConjs = new ArrayList<RexNode>();
        relDataTypeField = partitionColumnIndexes.iterator();
        while (relDataTypeField.hasNext()) {
            int partColIndex = (Integer)relDataTypeField.next();
            RexInputRef leftRef = rexBuilder.makeInputRef(((RelDataTypeField)mvBranch.getRowType().getFieldList().get(partColIndex)).getType(), partColIndex);
            RexInputRef rightRef = rexBuilder.makeInputRef(((RelDataTypeField)queryBranch.getRowType().getFieldList().get(partColIndex)).getType(), partColIndex + mvBranch.getRowType().getFieldCount());
            joinConjs.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{leftRef, rightRef}));
        }
        RexNode joinCond = RexUtil.composeConjunction((RexBuilder)rexBuilder, joinConjs);
        RelBuilder builder = call.builder();
        RelNode newNode = builder.push(mvBranch).push(queryBranch).join(JoinRelType.SEMI, joinCond).push(queryBranch).union(union.all).aggregate(builder.groupKey(aggregate.getGroupSet()), aggregate.getAggCallList()).build();
        call.transformTo(newNode);
    }
}

