/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.fs.FSStatsPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotateRunTimeStatsOptimizer
implements PhysicalPlanResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotateRunTimeStatsOptimizer.class);

    public static void setOrAnnotateStats(Set<Operator<? extends OperatorDesc>> ops, ParseContext pctx) throws SemanticException {
        for (Operator<? extends OperatorDesc> op : ops) {
            if (pctx.getContext().getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
                AnnotateRunTimeStatsOptimizer.setRuntimeStatsDir(op, pctx);
                continue;
            }
            if (pctx.getContext().getExplainAnalyze() == ExplainConfiguration.AnalyzeState.ANALYZING) {
                AnnotateRunTimeStatsOptimizer.annotateRuntimeStats(op, pctx);
                continue;
            }
            throw new SemanticException("Unexpected stats in AnnotateWithRunTimeStatistics.");
        }
    }

    private static void setRuntimeStatsDir(Operator<? extends OperatorDesc> op, ParseContext pctx) throws SemanticException {
        try {
            OperatorDesc conf = op.getConf();
            if (conf != null) {
                LOG.info("setRuntimeStatsDir for " + op.getOperatorId());
                String path = new Path(pctx.getContext().getExplainConfig().getExplainRootPath(), op.getOperatorId()).toString();
                FSStatsPublisher statsPublisher = new FSStatsPublisher();
                StatsCollectionContext runtimeStatsContext = new StatsCollectionContext((Configuration)pctx.getConf());
                runtimeStatsContext.setStatsTmpDir(path);
                if (!statsPublisher.init(runtimeStatsContext)) {
                    LOG.error("StatsPublishing error: StatsPublisher is not initialized.");
                    throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
                }
                conf.setRuntimeStatsTmpDir(path);
            } else {
                LOG.debug("skip setRuntimeStatsDir for " + op.getOperatorId() + " because OperatorDesc is null");
            }
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
    }

    private static void annotateRuntimeStats(Operator<? extends OperatorDesc> op, ParseContext pctx) {
        Long runTimeNumRows = pctx.getContext().getExplainConfig().getOpIdToRuntimeNumRows().get(op.getOperatorId());
        if (op.getConf() != null && op.getConf().getStatistics() != null && runTimeNumRows != null) {
            LOG.info("annotateRuntimeStats for " + op.getOperatorId());
            op.getConf().getStatistics().setRunTimeNumRows(runTimeNumRows);
        } else {
            LOG.debug("skip annotateRuntimeStats for " + op.getOperatorId());
        }
    }

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        AnnotateRunTimeStatsDispatcher disp = new AnnotateRunTimeStatsDispatcher(this, pctx, opRules);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    public void resolve(Set<Operator<?>> opSet, ParseContext pctx) throws SemanticException {
        Set<Operator<? extends OperatorDesc>> ops = OperatorUtils.getAllOperatorsForSimpleFetch(opSet);
        AnnotateRunTimeStatsOptimizer.setOrAnnotateStats(ops, pctx);
    }

    private class AnnotateRunTimeStatsDispatcher
    implements SemanticDispatcher {
        private final PhysicalContext physicalContext;

        public AnnotateRunTimeStatsDispatcher(AnnotateRunTimeStatsOptimizer annotateRunTimeStatsOptimizer, PhysicalContext context, Map<SemanticRule, SemanticNodeProcessor> rules) {
            this.physicalContext = context;
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task currTask = (Task)nd;
            HashSet<Operator<? extends OperatorDesc>> ops = new HashSet<Operator<? extends OperatorDesc>>();
            if (currTask instanceof MapRedTask) {
                MapRedTask mr = (MapRedTask)currTask;
                ops.addAll(((MapredWork)mr.getWork()).getAllOperators());
            } else if (currTask instanceof TezTask) {
                TezWork work = (TezWork)((TezTask)currTask).getWork();
                for (BaseWork w : work.getAllWork()) {
                    ops.addAll(w.getAllOperators());
                }
            }
            AnnotateRunTimeStatsOptimizer.setOrAnnotateStats(ops, this.physicalContext.getParseContext());
            return null;
        }
    }
}

