/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class InsertHandler
extends AbstractEventHandler<InsertMessage> {
    InsertHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    InsertMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getInsertMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        Partition ptn;
        if (withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY)) {
            return;
        }
        Table qlMdTable = this.tableObject((InsertMessage)this.eventMessage);
        if (TableType.EXTERNAL_TABLE.equals((Object)qlMdTable.getTableType())) {
            withinContext.replicationSpec.setNoop(true);
        }
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTable, true, withinContext.getTablesForBootstrap(), withinContext.oldReplScope, withinContext.hiveConf)) {
            return;
        }
        assert (!AcidUtils.isTransactionalTable(qlMdTable));
        List<Partition> qlPtns = null;
        if (qlMdTable.isPartitioned() && null != ((InsertMessage)this.eventMessage).getPtnObj()) {
            qlPtns = Collections.singletonList(this.partitionObject(qlMdTable, (InsertMessage)this.eventMessage));
        }
        Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
        withinContext.replicationSpec.setIsReplace(((InsertMessage)this.eventMessage).isReplace());
        EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, qlPtns, withinContext.replicationSpec, withinContext.hiveConf);
        Iterable files = ((InsertMessage)this.eventMessage).getFiles();
        boolean copyAtLoad = withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        Partition partition = ptn = null == qlPtns || qlPtns.isEmpty() ? null : qlPtns.get(0);
        if (files != null) {
            if (copyAtLoad) {
                Path dataPath = null;
                dataPath = null == qlPtns || qlPtns.isEmpty() ? new Path(withinContext.eventRoot, "data") : new Path(withinContext.eventRoot, "data" + File.separator + qlPtns.get(0).getName());
                this.writeEncodedDumpFiles(withinContext, files, dataPath);
            } else {
                for (String file : files) {
                    this.writeFileEntry(qlMdTable, ptn, file, withinContext);
                }
            }
        }
        LOG.info("Processing#{} INSERT message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.eventMessageAsJSON);
        dmd.write();
    }

    private Table tableObject(InsertMessage insertMsg) throws Exception {
        return new Table(insertMsg.getTableObj());
    }

    private Partition partitionObject(Table qlMdTable, InsertMessage insertMsg) throws Exception {
        return new Partition(qlMdTable, insertMsg.getPtnObj());
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_INSERT;
    }
}

