/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.constraint.Constraints;
import org.apache.hadoop.hive.ql.ddl.table.constraint.add.AlterTableAddConstraintDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class AddForeignKeyHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        List fks;
        AddForeignKeyMessage msg = this.deserializer.getAddForeignKeyMessage(context.dmd.getPayload());
        try {
            fks = msg.getForeignKeys();
        }
        catch (Exception e) {
            if (!(e instanceof SemanticException)) {
                throw new SemanticException("Error reading message members", (Throwable)e);
            }
            throw (SemanticException)((Object)e);
        }
        ArrayList tasks = new ArrayList();
        if (fks.isEmpty()) {
            return tasks;
        }
        String actualDbName = context.isDbNameEmpty() ? ((SQLForeignKey)fks.get(0)).getFktable_db() : context.dbName;
        String actualTblName = ((SQLForeignKey)fks.get(0)).getFktable_name();
        TableName tName = TableName.fromString((String)actualTblName, null, (String)actualDbName);
        for (SQLForeignKey fk : fks) {
            if (fk.getPktable_db().equals(fk.getFktable_db())) {
                fk.setPktable_db(actualDbName);
            }
            fk.setFktable_db(actualDbName);
            fk.setFktable_name(actualTblName);
        }
        Constraints constraints = new Constraints(null, fks, null, null, null, null);
        AlterTableAddConstraintDesc addConstraintsDesc = new AlterTableAddConstraintDesc(tName, context.eventOnlyReplicationSpec(), constraints);
        Task<DDLWork> addConstraintsTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, addConstraintsDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        tasks.add(addConstraintsTask);
        context.log.debug("Added add constrains task : {}:{}", (Object)addConstraintsTask.getId(), (Object)actualTblName);
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, null);
        return Collections.singletonList(addConstraintsTask);
    }
}

