/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionsMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.misc.truncate.TruncateTableDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class TruncatePartitionHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        try {
            if (MetastoreConf.getBoolVar((Configuration)context.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.NOTIFICATION_ALTER_PARTITIONS_V2_ENABLED)) {
                AlterPartitionsMessage singleMsg = this.deserializer.getAlterPartitionsMessage(context.dmd.getPayload());
                Table tblObj = singleMsg.getTableObj();
                TableName tName = TableName.fromString((String)singleMsg.getTable(), null, (String)(context.isDbNameEmpty() ? singleMsg.getDB() : context.dbName));
                List afterPartitionsList = singleMsg.getPartitions();
                ArrayList childTaskList = new ArrayList();
                for (Map afterIteratorMap : afterPartitionsList) {
                    LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
                    for (FieldSchema fs : tblObj.getPartitionKeys()) {
                        partSpec.put(fs.getName(), (String)afterIteratorMap.get(fs.getName()));
                    }
                    childTaskList.addAll(this.handleSingleAlterPartition(context, tName, partSpec, singleMsg.getWriteId()));
                }
                return childTaskList;
            }
            AlterPartitionMessage msg = this.deserializer.getAlterPartitionMessage(context.dmd.getPayload());
            TableName tName = TableName.fromString((String)msg.getTable(), null, (String)(context.isDbNameEmpty() ? msg.getDB() : context.dbName));
            Table tblObj = msg.getTableObj();
            Iterator afterIterator = msg.getPtnObjAfter().getValuesIterator();
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            for (FieldSchema fs : tblObj.getPartitionKeys()) {
                partSpec.put(fs.getName(), (String)afterIterator.next());
            }
            return this.handleSingleAlterPartition(context, tName, partSpec, msg.getWriteId());
        }
        catch (Exception e) {
            if (!(e instanceof SemanticException)) {
                throw new SemanticException("Error reading message members", (Throwable)e);
            }
            throw (SemanticException)((Object)e);
        }
    }

    private List<Task<?>> handleSingleAlterPartition(MessageHandler.Context context, TableName tName, Map<String, String> partSpec, Long writeId) throws SemanticException {
        TruncateTableDesc truncateTableDesc = new TruncateTableDesc(tName, partSpec, context.eventOnlyReplicationSpec());
        truncateTableDesc.setWriteId(writeId);
        Task<DDLWork> truncatePtnTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, truncateTableDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        context.log.debug("Added truncate ptn task : {}:{}:{}", new Object[]{truncatePtnTask.getId(), truncateTableDesc.getTableName(), truncateTableDesc.getWriteId()});
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), tName.getDb(), tName.getTable(), partSpec);
        try {
            return ReplUtils.addChildTask(truncatePtnTask);
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage());
        }
    }
}

