/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.Util;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.HiveFunctionInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRexExecutorImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExtractDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFloorDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIn;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveToDateSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveToUnixTimestampSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnixTimestampSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.RexNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.FunctionHelper;
import org.apache.hadoop.hive.ql.parse.type.RexNodeTypeCheck;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveFunctionHelper
implements FunctionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HiveFunctionHelper.class);
    private final RexBuilder rexBuilder;
    private final int maxNodesForInToOrTransformation;

    public HiveFunctionHelper(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
        try {
            this.maxNodesForInToOrTransformation = HiveConf.getIntVar((Configuration)Hive.get().getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPT_TRANSFORM_IN_MAXNODES);
        }
        catch (HiveException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public FunctionInfo getFunctionInfo(String functionText) throws SemanticException {
        return new HiveFunctionInfo(FunctionRegistry.getFunctionInfo(functionText));
    }

    @Override
    public RelDataType getReturnType(FunctionInfo fi, List<RexNode> inputs) throws SemanticException {
        ObjectInspector[] inputsOIs = new ObjectInspector[inputs.size()];
        for (int i = 0; i < inputsOIs.length; ++i) {
            inputsOIs[i] = this.createObjectInspector(inputs.get(i));
        }
        ObjectInspector oi = fi.getGenericUDF() != null ? fi.getGenericUDF().initializeAndFoldConstants(inputsOIs) : fi.getGenericUDTF().initialize(inputsOIs);
        return TypeConverter.convert(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi), this.rexBuilder.getTypeFactory());
    }

    @Override
    public List<RexNode> convertInputs(FunctionInfo fi, List<RexNode> inputs, RelDataType returnType) throws SemanticException {
        boolean isIN;
        GenericUDF genericUDF = fi.getGenericUDF();
        TypeInfo typeInfo = TypeConverter.convert(returnType);
        TypeInfo targetType = null;
        boolean isNumeric = genericUDF instanceof GenericUDFBaseBinary && typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP == PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
        boolean isCompare = !isNumeric && genericUDF instanceof GenericUDFBaseCompare;
        boolean isBetween = !isNumeric && genericUDF instanceof GenericUDFBetween;
        boolean bl = isIN = !isNumeric && genericUDF instanceof GenericUDFIn;
        if (isNumeric) {
            targetType = typeInfo;
        } else if (genericUDF instanceof GenericUDFBaseCompare) {
            targetType = FunctionRegistry.getCommonClassForComparison(TypeConverter.convert(inputs.get(0).getType()), TypeConverter.convert(inputs.get(1).getType()));
        } else if (genericUDF instanceof GenericUDFBetween) {
            assert (inputs.size() == 4);
            targetType = FunctionRegistry.getCommonClassForComparison(TypeConverter.convert(inputs.get(1).getType()), FunctionRegistry.getCommonClassForComparison(TypeConverter.convert(inputs.get(2).getType()), TypeConverter.convert(inputs.get(3).getType())));
        } else if (genericUDF instanceof GenericUDFIn) {
            assert (inputs.size() > 1);
            targetType = FunctionRegistry.getCommonClassForComparison(TypeConverter.convert(inputs.get(0).getType()), TypeConverter.convert(inputs.get(1).getType()));
        }
        if (targetType != null) {
            ArrayList<RexNode> newInputs = new ArrayList<RexNode>();
            for (int i = 0; i < inputs.size(); ++i) {
                RexNode input = inputs.get(i);
                TypeInfo inputTypeInfo = TypeConverter.convert(input.getType());
                RexNode tmpExprNode = input;
                if (TypeInfoUtils.isConversionRequiredForComparison((TypeInfo)targetType, (TypeInfo)inputTypeInfo)) {
                    if (isIN || isCompare) {
                        tmpExprNode = this.convert(targetType, input);
                    } else if (isBetween) {
                        if (i > 0) {
                            tmpExprNode = this.convert(targetType, input);
                        }
                    } else if (isNumeric) {
                        PrimitiveTypeInfo minArgType = ExprNodeDescUtils.deriveMinArgumentCast(inputTypeInfo, targetType);
                        tmpExprNode = this.convert((TypeInfo)minArgType, input);
                    } else {
                        throw new AssertionError((Object)("Unexpected " + String.valueOf(targetType) + " - not a numeric op or compare"));
                    }
                }
                newInputs.add(tmpExprNode);
            }
            return newInputs;
        }
        return inputs;
    }

    private RexNode convert(TypeInfo targetType, RexNode input) throws SemanticException {
        if (targetType.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return (RexNode)RexNodeTypeCheck.getExprNodeDefaultExprProcessor(this.rexBuilder).createConversionCast(input, (PrimitiveTypeInfo)targetType);
        }
        StructTypeInfo structTypeInfo = (StructTypeInfo)targetType;
        RexCall call = (RexCall)input;
        ArrayList<RexNode> exprNodes = new ArrayList<RexNode>();
        for (int j = 0; j < structTypeInfo.getAllStructFieldTypeInfos().size(); ++j) {
            exprNodes.add(this.convert((TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(j), (RexNode)call.getOperands().get(j)));
        }
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROW, exprNodes);
    }

    @Override
    public RexNode getExpression(String functionText, FunctionInfo fi, List<RexNode> inputs, RelDataType returnType) throws SemanticException {
        RexNode expr = RexNodeConverter.handleExplicitCast(fi.getGenericUDF(), returnType, inputs, this.rexBuilder);
        if (expr == null) {
            ImmutableList.Builder argsTypes = ImmutableList.builder();
            for (RexNode input : inputs) {
                argsTypes.add((Object)input.getType());
            }
            SqlOperator calciteOp = SqlFunctionConverter.getCalciteOperator(functionText, fi.getGenericUDF(), (ImmutableList<RelDataType>)argsTypes.build(), returnType);
            if (calciteOp.getKind() == SqlKind.CASE) {
                inputs = RexNodeConverter.rewriteCaseChildren(inputs, this.rexBuilder);
                inputs = RexNodeConverter.adjustCaseBranchTypes(inputs, returnType, this.rexBuilder);
                this.checkForStatefulFunctions(inputs);
            } else if (HiveExtractDate.ALL_FUNCTIONS.contains(calciteOp)) {
                inputs = RexNodeConverter.rewriteExtractDateChildren(calciteOp, inputs, this.rexBuilder);
            } else if (HiveFloorDate.ALL_FUNCTIONS.contains(calciteOp)) {
                inputs = RexNodeConverter.rewriteFloorDateChildren(calciteOp, inputs, this.rexBuilder);
            } else if (HiveIn.INSTANCE.equals((Object)calciteOp)) {
                List<RexNode> newInputs;
                boolean rewriteToOr = true;
                if (this.maxNodesForInToOrTransformation != 0 && inputs.size() > this.maxNodesForInToOrTransformation) {
                    rewriteToOr = false;
                }
                if (rewriteToOr && (newInputs = RexNodeConverter.transformInToOrOperands(inputs, this.rexBuilder)) != null) {
                    inputs = newInputs;
                    if (inputs.size() == 1) {
                        inputs.add((RexNode)this.rexBuilder.makeLiteral(false));
                    }
                    calciteOp = SqlStdOperatorTable.OR;
                }
            } else if (calciteOp.getKind() == SqlKind.COALESCE && inputs.size() > 1) {
                calciteOp = SqlStdOperatorTable.CASE;
                inputs = RexNodeConverter.rewriteCoalesceChildren(inputs, this.rexBuilder);
                inputs = RexNodeConverter.adjustCaseBranchTypes(inputs, returnType, this.rexBuilder);
                this.checkForStatefulFunctions(inputs);
            } else if (calciteOp == HiveToDateSqlOperator.INSTANCE) {
                inputs = RexNodeConverter.rewriteToDateChildren(inputs, this.rexBuilder);
            } else if (calciteOp.getKind() == SqlKind.BETWEEN) {
                SqlBinaryOperator cmpOp;
                assert (inputs.get(0).isAlwaysTrue() || inputs.get(0).isAlwaysFalse());
                boolean invert = inputs.get(0).isAlwaysTrue();
                if (invert) {
                    calciteOp = SqlStdOperatorTable.OR;
                    cmpOp = SqlStdOperatorTable.GREATER_THAN;
                } else {
                    calciteOp = SqlStdOperatorTable.AND;
                    cmpOp = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                }
                RexNode op = inputs.get(1);
                RexNode rangeL = inputs.get(2);
                RexNode rangeH = inputs.get(3);
                inputs = new ArrayList<RexNode>();
                inputs.add(this.rexBuilder.makeCall((SqlOperator)cmpOp, new RexNode[]{rangeL, op}));
                inputs.add(this.rexBuilder.makeCall((SqlOperator)cmpOp, new RexNode[]{op, rangeH}));
            } else if (calciteOp == HiveUnixTimestampSqlOperator.INSTANCE && inputs.size() > 0) {
                calciteOp = HiveToUnixTimestampSqlOperator.INSTANCE;
            }
            expr = this.rexBuilder.makeCall(returnType, calciteOp, inputs);
        }
        if (expr instanceof RexCall && !expr.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)expr;
            expr = this.rexBuilder.makeCall(returnType, call.getOperator(), RexUtil.flatten((List)call.getOperands(), (SqlOperator)call.getOperator()));
        }
        return expr;
    }

    private void checkForStatefulFunctions(List<RexNode> exprs) throws SemanticException {
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(this, true){

            public Void visitCall(RexCall call) {
                GenericUDF nodeUDF = SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), call.getOperands().size());
                if (nodeUDF == null) {
                    throw new AssertionError((Object)("Cannot retrieve function " + call.getOperator().getName() + " within StatefulFunctionsChecker"));
                }
                if (FunctionRegistry.isStateful(nodeUDF)) {
                    throw new Util.FoundOne((Object)call);
                }
                return (Void)super.visitCall(call);
            }
        };
        try {
            for (RexNode expr : exprs) {
                expr.accept((RexVisitor)visitor);
            }
        }
        catch (Util.FoundOne e) {
            throw new SemanticException("Stateful expressions cannot be used inside of CASE");
        }
    }

    @Override
    public FunctionHelper.AggregateInfo getAggregateFunctionInfo(boolean isDistinct, boolean isAllColumns, String aggregateName, List<RexNode> aggregateParameters, List<FunctionHelper.FieldCollation> fieldCollations) throws SemanticException {
        GenericUDAFEvaluator.Mode udafMode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
        ArrayList<ObjectInspector> aggParameterOIs = new ArrayList<ObjectInspector>();
        Iterator<FunctionHelper.FieldCollation> obKeyIterator = fieldCollations.iterator();
        for (RexNode aggParameter : aggregateParameters) {
            aggParameterOIs.add(this.createObjectInspector(aggParameter));
            if (!obKeyIterator.hasNext()) continue;
            FunctionHelper.FieldCollation fieldCollation = obKeyIterator.next();
            aggParameterOIs.add(this.createObjectInspector(fieldCollation.getSortExpression()));
            aggParameterOIs.add((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(fieldCollation.getSortDirection())));
            aggParameterOIs.add((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(fieldCollation.getNullOrdering().getCode())));
        }
        GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator2(aggregateName, aggParameterOIs, null, isDistinct, isAllColumns);
        assert (genericUDAFEvaluator != null);
        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo2(genericUDAFEvaluator, udafMode, aggParameterOIs);
        return new FunctionHelper.AggregateInfo(aggregateParameters, udaf.returnType, aggregateName, isDistinct, fieldCollations);
    }

    @Override
    public FunctionHelper.AggregateInfo getWindowAggregateFunctionInfo(boolean isDistinct, boolean isAllColumns, String aggregateName, List<RexNode> aggregateParameters) throws SemanticException {
        PrimitiveTypeInfo returnType = null;
        if (FunctionRegistry.isRankingFunction(aggregateName)) {
            returnType = aggregateName.equalsIgnoreCase("percent_rank") || aggregateName.equalsIgnoreCase("cume_dist") ? TypeInfoFactory.doubleTypeInfo : TypeInfoFactory.intTypeInfo;
        } else {
            try {
                GenericUDAFEvaluator.Mode udafMode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                ArrayList<ObjectInspector> aggParameterOIs = new ArrayList<ObjectInspector>();
                for (RexNode aggParameter : aggregateParameters) {
                    aggParameterOIs.add(this.createObjectInspector(aggParameter));
                }
                if (aggregateName.toLowerCase().equals("lead") || aggregateName.toLowerCase().equals("lag")) {
                    genericUDAFEvaluator = FunctionRegistry.getGenericWindowingEvaluator(aggregateName, aggParameterOIs, isDistinct, isAllColumns, true);
                    udaf = SemanticAnalyzer.getGenericUDAFInfo2(genericUDAFEvaluator, udafMode, aggParameterOIs);
                    returnType = ((ListTypeInfo)udaf.returnType).getListElementTypeInfo();
                } else {
                    genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator2(aggregateName, aggParameterOIs, null, isDistinct, isAllColumns);
                    assert (genericUDAFEvaluator != null);
                    udaf = SemanticAnalyzer.getGenericUDAFInfo2(genericUDAFEvaluator, udafMode, aggParameterOIs);
                    returnType = FunctionRegistry.pivotResult(aggregateName) ? ((ListTypeInfo)udaf.returnType).getListElementTypeInfo() : udaf.returnType;
                }
            }
            catch (Exception e) {
                LOG.debug("CBO: Couldn't Obtain UDAF evaluators for " + aggregateName + ", trying to translate to GenericUDF");
            }
        }
        return returnType != null ? new FunctionHelper.AggregateInfo(aggregateParameters, (TypeInfo)returnType, aggregateName, isDistinct) : null;
    }

    @Override
    public RexCall getUDTFFunction(String functionName, List<RexNode> operands) throws SemanticException {
        List operandTypes = Lists.transform(operands, RexNode::getType);
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(functionName);
        GenericUDTF genericUDTF = functionInfo.getGenericUDTF();
        Preconditions.checkNotNull((Object)genericUDTF, (Object)("Generic UDTF not found: " + functionName));
        RelDataType udtfRetType = this.getReturnType(functionInfo, operands);
        SqlOperator calciteOp = SqlFunctionConverter.getCalciteOperator(functionName, genericUDTF, (ImmutableList<RelDataType>)ImmutableList.copyOf((Collection)operandTypes), udtfRetType);
        return (RexCall)this.rexBuilder.makeCall(calciteOp, operands);
    }

    private ObjectInspector createObjectInspector(RexNode expr) {
        ConstantObjectInspector oi = this.createConstantObjectInspector(expr);
        if (oi != null) {
            return oi;
        }
        return TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)TypeConverter.convert(expr.getType()));
    }

    private ConstantObjectInspector createConstantObjectInspector(RexNode expr) {
        if (RexUtil.isLiteral((RexNode)expr, (boolean)true)) {
            ExprNodeConstantDesc constant;
            if (expr.isA(SqlKind.LITERAL)) {
                constant = ExprNodeConverter.toExprNodeConstantDesc((RexLiteral)expr);
            } else {
                RexNode foldedExpr = this.foldExpression(expr);
                if (!foldedExpr.isA(SqlKind.LITERAL)) {
                    return null;
                }
                constant = ExprNodeConverter.toExprNodeConstantDesc((RexLiteral)foldedExpr);
            }
            PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)constant.getTypeInfo();
            Object value = constant.getValue();
            Object writableValue = value == null ? null : PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)typeInfo).getPrimitiveWritableObject(value);
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)typeInfo, (Object)writableValue);
        }
        if (expr instanceof RexCall) {
            RexCall call = (RexCall)expr;
            if (call.getOperator() == SqlStdOperatorTable.ROW) {
                ArrayList<String> fieldNames = new ArrayList<String>();
                ArrayList<ConstantObjectInspector> fieldObjectInspectors = new ArrayList<ConstantObjectInspector>();
                ArrayList<Object> writableValues = new ArrayList<Object>();
                for (int i = 0; i < call.getOperands().size(); ++i) {
                    RexNode input = (RexNode)call.getOperands().get(i);
                    ConstantObjectInspector objectInspector = this.createConstantObjectInspector(input);
                    if (objectInspector == null) {
                        return null;
                    }
                    fieldNames.add(((RelDataTypeField)expr.getType().getFieldList().get(i)).getName());
                    fieldObjectInspectors.add(objectInspector);
                    writableValues.add(objectInspector.getWritableConstantValue());
                }
                return ObjectInspectorFactory.getStandardConstantStructObjectInspector(fieldNames, fieldObjectInspectors, writableValues);
            }
            if (call.getOperator() == SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR) {
                ListTypeInfo listTypeInfo = (ListTypeInfo)TypeConverter.convert(expr.getType());
                TypeInfo typeInfo = listTypeInfo.getListElementTypeInfo();
                ArrayList<Object> writableValues = new ArrayList<Object>();
                for (RexNode input : call.getOperands()) {
                    ConstantObjectInspector objectInspector = this.createConstantObjectInspector(input);
                    if (objectInspector == null) {
                        return null;
                    }
                    writableValues.add(objectInspector.getWritableConstantValue());
                }
                return ObjectInspectorFactory.getStandardConstantListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), writableValues);
            }
            if (call.getOperator() == SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR) {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)TypeConverter.convert(expr.getType());
                HashMap<Object, Object> writableValues = new HashMap<Object, Object>();
                Iterator it = call.getOperands().iterator();
                while (it.hasNext()) {
                    ConstantObjectInspector keyObjectInspector = this.createConstantObjectInspector((RexNode)it.next());
                    if (keyObjectInspector == null) {
                        return null;
                    }
                    ConstantObjectInspector valueObjectInspector = this.createConstantObjectInspector((RexNode)it.next());
                    if (valueObjectInspector == null) {
                        return null;
                    }
                    writableValues.put(keyObjectInspector.getWritableConstantValue(), valueObjectInspector.getWritableConstantValue());
                }
                return ObjectInspectorFactory.getStandardConstantMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)mapTypeInfo.getMapKeyTypeInfo()), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)mapTypeInfo.getMapValueTypeInfo()), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), writableValues);
            }
        }
        return null;
    }

    @Override
    public RexNode foldExpression(RexNode expr) {
        HiveRexExecutorImpl executor = new HiveRexExecutorImpl();
        ArrayList<RexNode> result = new ArrayList<RexNode>();
        executor.reduce(this.rexBuilder, (List<RexNode>)ImmutableList.of((Object)expr), result);
        return (RexNode)result.get(0);
    }

    @Override
    public boolean isAndFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFOPAnd;
    }

    @Override
    public boolean isOrFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFOPOr;
    }

    @Override
    public boolean isInFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFIn;
    }

    @Override
    public boolean isCompareFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFBaseCompare;
    }

    @Override
    public boolean isEqualFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFOPEqual && !(fi.getGenericUDF() instanceof GenericUDFOPEqualNS);
    }

    @Override
    public boolean isNSCompareFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFOPEqualNS || fi.getGenericUDF() instanceof GenericUDFOPNotEqualNS;
    }

    @Override
    public boolean isConsistentWithinQuery(FunctionInfo fi) {
        return FunctionRegistry.isConsistentWithinQuery(fi.getGenericUDF());
    }

    @Override
    public boolean isStateful(FunctionInfo fi) {
        GenericUDF genericUDF = fi.getGenericUDF();
        if (genericUDF == null) {
            return false;
        }
        return FunctionRegistry.isStateful(fi.getGenericUDF());
    }
}

