/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.queryhistory.repository;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.PartitionTransform;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.queryhistory.repository.QueryHistoryRepository;
import org.apache.hadoop.hive.ql.queryhistory.schema.Schema;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository
implements QueryHistoryRepository {
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());
    @VisibleForTesting
    HiveConf conf;
    protected Schema schema;
    private Warehouse warehouse;

    @Override
    public void init(HiveConf conf, Schema schema) {
        this.conf = conf;
        this.schema = schema;
        try {
            this.warehouse = new Warehouse((Configuration)conf);
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
        this.initializeSessionForTableCreation();
        try (Hive hive = Hive.get(conf);){
            Database database = this.initDatabase(hive);
            Table table = this.initTable(hive, database);
            this.postInitTable(table);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeSessionForTableCreation() {
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID, (String)"query_history_service_query_id_for_table_creation");
        SessionState ss = SessionState.get();
        if (ss == null) {
            ss = SessionState.start(this.conf);
        }
        ss.addQueryState("query_history_service_query_id_for_table_creation", new QueryState.Builder().withHiveConf(this.conf).build());
    }

    protected Database initDatabase(Hive hive) {
        try {
            Database db = hive.getDatabase("sys");
            if (db == null) {
                this.LOG.warn("Database ({}) for query history table hasn't been found, auto-creating one", (Object)"sys");
                String location = this.getDatabaseLocation("sys");
                db = new Database("sys", "Hive SYS database", location, null);
                hive.createDatabase(db, false);
            }
            return db;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getDatabaseLocation(String databaseName) throws Exception {
        return this.warehouse.getDefaultExternalDatabasePath(databaseName).toUri().toString();
    }

    protected Table initTable(Hive hive, Database db) {
        try {
            Table table = hive.getTable("sys", "query_history", null, false);
            if (table == null) {
                this.LOG.info("Query history table ({}) isn't created yet", (Object)"query_history");
                table = this.createTable(hive, db);
            }
            return table;
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void postInitTable(Table var1) throws Exception;

    protected abstract Table createTable(Hive var1, Database var2) throws HiveException;

    protected Table createTableObject() {
        Table table = new Table("sys", "query_history");
        table.setProperty("EXTERNAL", "TRUE");
        table.setTableType(TableType.EXTERNAL_TABLE);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.addAll(this.schema.getPartCols());
        List<TransformSpec> spec = PartitionTransform.getPartitionTransformSpec(partCols);
        SessionStateUtil.addResourceOrThrow((Configuration)this.conf, "partition_transform_spec", spec);
        return table;
    }
}

