/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.tez.TezRuntimeException;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReExecuteLostAMQueryPlugin
implements IReExecutionPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ReExecuteLostAMQueryPlugin.class);
    private static final Pattern LOST_AM_CONTAINER_ERROR_PATTERN = Pattern.compile(".*AM Container for .* exited .* exitCode: -100.*", 32);
    private static final String UNMANAGED_AM_FAILURE = "AM record not found (likely died)";
    private static final String DAG_LOST_FAILURE = "No running DAG at present";
    private boolean retryPossible;
    private Set<String> dagIds = new HashSet<String>();

    @Override
    public void initialize(Driver driver) {
        driver.getHookRunner().addOnFailureHook(new LocalHook());
    }

    @Override
    public boolean shouldReExecute(int executionNum) {
        return this.retryPossible;
    }

    @Override
    public boolean shouldReExecuteAfterCompile(int executionNum, PlanMapper oldPlanMapper, PlanMapper newPlanMapper) {
        return this.retryPossible;
    }

    class LocalHook
    implements ExecuteWithHookContext {
        LocalHook() {
        }

        @Override
        public void run(HookContext hookContext) throws Exception {
            if (hookContext.getHookType() == HookContext.HookType.ON_FAILURE_HOOK) {
                Throwable exception = hookContext.getException();
                if (!(exception instanceof TezRuntimeException)) {
                    LOG.info("Exception is not a TezRuntimeException, no need to check further with ReExecuteLostAMQueryPlugin");
                    return;
                }
                TezRuntimeException tre = (TezRuntimeException)((Object)exception);
                String message = tre.getMessage();
                if (message != null) {
                    ReExecuteLostAMQueryPlugin.this.dagIds.add(tre.getDagId());
                    if (LOST_AM_CONTAINER_ERROR_PATTERN.matcher(message).matches() || message.contains(ReExecuteLostAMQueryPlugin.UNMANAGED_AM_FAILURE) || message.contains(ReExecuteLostAMQueryPlugin.DAG_LOST_FAILURE)) {
                        ReExecuteLostAMQueryPlugin.this.retryPossible = true;
                    }
                    LOG.info("Got exception message: {} retryPossible: {}, dags seen so far: {}", new Object[]{message, ReExecuteLostAMQueryPlugin.this.retryPossible, ReExecuteLostAMQueryPlugin.this.dagIds});
                }
            }
        }
    }
}

