/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;

@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
@InterfaceStability.Evolving
@InterfaceStability.Unstable
public class SettableConfigUpdater {
    public static void setHiveConfWhiteList(HiveConf hiveConf) throws HiveAuthzPluginException {
        Object whiteListParamsStr = hiveConf.getVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST);
        if (whiteListParamsStr == null || ((String)whiteListParamsStr).trim().isEmpty()) {
            throw new HiveAuthzPluginException("Configuration parameter " + HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST.varname + " is not initialized.");
        }
        String whiteListAppend = hiveConf.getVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST_APPEND);
        if (whiteListAppend != null && !whiteListAppend.trim().equals("")) {
            whiteListParamsStr = (String)whiteListParamsStr + "|" + whiteListAppend;
        }
        hiveConf.setModifiableWhiteListRegex((String)whiteListParamsStr);
        String curBlackList = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_BLACKLIST);
        if (curBlackList == null || curBlackList.trim().isEmpty()) {
            hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_BLACKLIST, "reflect,reflect2,java_method,in_file");
        }
    }
}

