/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.List;
import org.apache.hadoop.fs.Path;

public class CleanupRequest {
    private final String location;
    private final List<Path> obsoleteDirs;
    private final boolean purge;
    private final String runAs;
    private final String dbName;
    private final String fullPartitionName;

    public CleanupRequest(CleanupRequestBuilder builder) {
        this.location = builder.location;
        this.obsoleteDirs = builder.obsoleteDirs;
        this.purge = builder.purge;
        this.runAs = builder.runAs;
        this.dbName = builder.dbName;
        this.fullPartitionName = builder.fullPartitionName;
    }

    public String getLocation() {
        return this.location;
    }

    public List<Path> getObsoleteDirs() {
        return this.obsoleteDirs;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public String runAs() {
        return this.runAs;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getFullPartitionName() {
        return this.fullPartitionName;
    }

    public static class CleanupRequestBuilder {
        private String location;
        private List<Path> obsoleteDirs;
        private boolean purge;
        private String runAs;
        private String dbName;
        private String fullPartitionName;

        public CleanupRequestBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public CleanupRequestBuilder setObsoleteDirs(List<Path> obsoleteDirs) {
            this.obsoleteDirs = obsoleteDirs;
            return this;
        }

        public CleanupRequestBuilder setPurge(boolean purge) {
            this.purge = purge;
            return this;
        }

        public CleanupRequestBuilder setDbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public CleanupRequestBuilder setRunAs(String runAs) {
            this.runAs = runAs;
            return this;
        }

        public CleanupRequestBuilder setFullPartitionName(String fullPartitionName) {
            this.fullPartitionName = fullPartitionName;
            return this;
        }

        public CleanupRequest build() {
            return new CleanupRequest(this);
        }
    }
}

