/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.hive_metastoreConstants;
import org.apache.hadoop.hive.ql.exec.DDLPlanUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompactionQueryBuilderForInsertOnly
extends CompactionQueryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompactionQueryBuilderForInsertOnly.class.getName());

    CompactionQueryBuilderForInsertOnly(CompactionType compactionType) {
        super(compactionType, true);
        if (CompactionType.REBALANCE.equals((Object)compactionType)) {
            throw new IllegalArgumentException("Rebalance compaction can only be supported on full ACID tables.");
        }
    }

    @Override
    protected void buildSelectClauseForInsert(StringBuilder query) {
        switch (this.compactionType) {
            case MAJOR: {
                if (this.sourcePartition != null) {
                    if (this.sourceTab == null) break;
                    List cols = this.sourceTab.getSd().getCols();
                    this.appendColumns(query, cols, false);
                    break;
                }
                query.append("*");
                break;
            }
            case MINOR: {
                if (this.sourceTab == null) break;
                List cols = this.sourceTab.getSd().getCols();
                this.appendColumns(query, cols, false);
            }
        }
    }

    @Override
    protected void getSourceForInsert(StringBuilder query) {
        super.getSourceForInsert(query);
        if (CompactionType.MAJOR.equals((Object)this.compactionType) && StringUtils.isNotBlank((CharSequence)this.orderByClause)) {
            query.append(this.orderByClause);
        }
    }

    @Override
    protected void buildWhereClauseForInsert(StringBuilder query) {
        if (CompactionType.MAJOR.equals((Object)this.compactionType)) {
            super.buildWhereClauseForInsert(query);
        }
    }

    @Override
    protected void getDdlForCreate(StringBuilder query) {
        this.defineColumns(query);
        if (this.isPartitioned) {
            query.append(" PARTITIONED BY (`file_name` STRING) ");
        }
        this.getMmBucketing(query);
        this.getSkewedByClause(query);
        this.copySerdeFromSourceTable(query);
        if (this.location != null) {
            query.append(" LOCATION '").append(HiveStringUtils.escapeHiveCommand((String)this.location)).append("'");
        }
        this.addTblProperties(query);
    }

    @Override
    protected void defineColumns(StringBuilder query) {
        if (this.sourceTab != null) {
            query.append("(");
            List<String> columnDescs = this.getColumnDescs();
            query.append(StringUtils.join(columnDescs, (char)','));
            query.append(") ");
        }
    }

    private void getMmBucketing(StringBuilder query) {
        List buckCols;
        if (this.sourceTab != null && !(buckCols = this.sourceTab.getSd().getBucketCols()).isEmpty()) {
            query.append("CLUSTERED BY (").append(StringUtils.join((Iterable)buckCols, (String)",")).append(") ");
            List sortCols = this.sourceTab.getSd().getSortCols();
            if (!sortCols.isEmpty()) {
                query.append("SORTED BY (");
                boolean isFirst = true;
                for (Order sortCol : sortCols) {
                    if (!isFirst) {
                        query.append(", ");
                    }
                    isFirst = false;
                    query.append(sortCol.getCol()).append(" ").append(DirectionUtils.codeToText(sortCol.getOrder()));
                }
                query.append(") ");
            }
            query.append("INTO ").append(this.sourceTab.getSd().getNumBuckets()).append(" BUCKETS");
        }
    }

    private void getSkewedByClause(StringBuilder query) {
        SkewedInfo skewedInfo;
        if (this.sourceTab != null && this.sourceTab.getSd().isStoredAsSubDirectories() && (skewedInfo = this.sourceTab.getSd().getSkewedInfo()) != null && !skewedInfo.getSkewedColNames().isEmpty()) {
            query.append(" SKEWED BY (").append(StringUtils.join((Iterable)skewedInfo.getSkewedColNames(), (String)", ")).append(") ON ");
            boolean isFirst = true;
            for (List colValues : skewedInfo.getSkewedColValues()) {
                if (!isFirst) {
                    query.append(", ");
                }
                isFirst = false;
                query.append("('").append(StringUtils.join((Iterable)colValues, (String)"','")).append("')");
            }
            query.append(") STORED AS DIRECTORIES");
        }
    }

    private static Set<String> getHiveMetastoreConstants() {
        HashSet<String> result = new HashSet<String>();
        for (Field f : hive_metastoreConstants.class.getDeclaredFields()) {
            if (!Modifier.isFinal(f.getModifiers()) || !String.class.equals(f.getType())) continue;
            f.setAccessible(true);
            try {
                result.add((String)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    protected void addTblProperties(StringBuilder query) {
        HashMap<String, String> tblProperties = new HashMap<String, String>();
        tblProperties.put("transactional", "false");
        if (this.sourceTab != null) {
            Set<String> excludes = CompactionQueryBuilderForInsertOnly.getHiveMetastoreConstants();
            excludes.addAll(StatsSetupConst.TABLE_PARAMS_STATS_KEYS);
            for (Map.Entry e : this.sourceTab.getParameters().entrySet()) {
                if (e.getValue() == null || excludes.contains(e.getKey())) continue;
                tblProperties.put((String)e.getKey(), HiveStringUtils.escapeHiveCommand((String)((String)e.getValue())));
            }
        }
        super.addTblProperties(query, tblProperties);
    }

    protected void copySerdeFromSourceTable(StringBuilder query) {
        if (this.storageDescriptor != null) {
            this.ensureTableToCompactIsNative();
            SerDeInfo serdeInfo = this.storageDescriptor.getSerdeInfo();
            Map serdeParams = serdeInfo.getParameters();
            query.append(" ROW FORMAT SERDE '").append(HiveStringUtils.escapeHiveCommand((String)serdeInfo.getSerializationLib())).append("'");
            if (!serdeParams.isEmpty()) {
                DDLPlanUtils.appendSerdeParams(query, serdeParams);
            }
            query.append("STORED AS INPUTFORMAT '").append(HiveStringUtils.escapeHiveCommand((String)this.storageDescriptor.getInputFormat())).append("'").append(" OUTPUTFORMAT '").append(HiveStringUtils.escapeHiveCommand((String)this.storageDescriptor.getOutputFormat())).append("'");
        }
    }

    private void ensureTableToCompactIsNative() {
        String storageHandler;
        if (this.sourceTab != null && (storageHandler = (String)this.sourceTab.getParameters().get("storage_handler")) != null) {
            String message = "Table " + this.sourceTab.getTableName() + " has a storage handler (" + storageHandler + "). Failing compaction for this non-native table.";
            LOG.error(message);
            throw new RuntimeException(message);
        }
    }
}

