/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidDirectory;

public class CompactorContext {
    private final HiveConf conf;
    private final Table table;
    private final Partition partition;
    private final StorageDescriptor sd;
    private final ValidWriteIdList validWriteIdList;
    private final CompactionInfo compactionInfo;
    private final AcidDirectory dir;
    public static final String COMPACTOR_THRESHOLD_PREFIX = "compactor.threshold";
    public static final String COMPACTION_FILE_SIZE_THRESHOLD = "compactor.threshold.file.size.threshold";
    public static final String COMPACTION_TARGET_SIZE = "compactor.threshold.target.size";
    public static final String COMPACTION_MIN_FRAGMENT_RATIO = "compactor.threshold.fragment.ratio";
    public static final String COMPACTION_MIN_TARGET_SIZE_RATIO = "compactor.threshold.min.target.size.ratio";
    public static final String COMPACTION_MIN_INPUT_FILES = "compactor.threshold.min.input.files";
    public static final String COMPACTION_DELETE_FILE_RATIO = "compactor.threshold.delete.file.ratio";

    public CompactorContext(HiveConf conf, Table table, Partition p, StorageDescriptor sd, ValidWriteIdList tblValidWriteIds, CompactionInfo ci, AcidDirectory dir) {
        this.conf = conf;
        this.table = table;
        this.partition = p;
        this.sd = sd;
        this.validWriteIdList = tblValidWriteIds;
        this.compactionInfo = ci;
        this.dir = dir;
    }

    public CompactorContext(HiveConf conf, Table table, CompactionInfo ci) {
        this(conf, table, null, null, null, ci, null);
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Table getTable() {
        return this.table;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public StorageDescriptor getSd() {
        return this.sd;
    }

    public ValidWriteIdList getValidWriteIdList() {
        return this.validWriteIdList;
    }

    public CompactionInfo getCompactionInfo() {
        return this.compactionInfo;
    }

    public AcidDirectory getAcidDirectory() {
        return this.dir;
    }
}

