/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileMerger {
    private final Configuration conf;
    private static final Logger LOG = LoggerFactory.getLogger(OrcFileMerger.class);

    public OrcFileMerger(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFiles(List<Reader> readers, Path outPath) throws IOException {
        try (Writer writer = null;){
            for (Reader reader : readers) {
                if (writer == null) {
                    writer = this.setupWriter(reader, outPath);
                }
                VectorizedRowBatch batch = reader.getSchema().createRowBatchV2();
                RecordReader rows = reader.rows();
                while (rows.nextBatch(batch)) {
                    if (batch == null) continue;
                    writer.addRowBatch(batch);
                }
                rows.close();
            }
        }
    }

    private Writer setupWriter(Reader reader, Path outPath) throws IOException {
        OrcFile.WriterOptions options = OrcFile.writerOptions(this.conf).compress(reader.getCompression()).version(reader.getFileVersion()).rowIndexStride(reader.getRowIndexStride()).inspector(reader.getObjectInspector());
        if (CompressionKind.NONE != reader.getCompression()) {
            options.bufferSize(reader.getCompressionSize()).enforceBufferSize();
        }
        Writer writer = OrcFile.createWriter(outPath, options);
        LOG.info("ORC merge file output path: {}", (Object)outPath);
        return writer;
    }

    public boolean checkCompatibility(List<Reader> readers) {
        if (readers == null || readers.isEmpty()) {
            return false;
        }
        if (!readers.stream().allMatch(r -> ((Reader)readers.get(0)).getSchema().equals((Object)r.getSchema()) && ((Reader)readers.get(0)).getCompression().equals((Object)r.getCompression()) && ((Reader)readers.get(0)).getCompressionSize() == r.getCompressionSize() && ((Reader)readers.get(0)).getFileVersion().equals((Object)r.getFileVersion()) && ((Reader)readers.get(0)).getWriterVersion().equals((Object)r.getWriterVersion()) && ((Reader)readers.get(0)).getRowIndexStride() == r.getRowIndexStride())) {
            LOG.warn("Incompatible ORC file merge!");
            return false;
        }
        return true;
    }
}

